#! /usr/bin/perl
# 
# $Id: autogen.pl,v 1.35 2005/12/28 09:30:56 lace Exp $
# Run to generate the initial Makefiles etc. after CVS checkout.
# Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; exactly version 2 of June 1991 is required
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


require 5.6.0;	# at least 'use warnings;' but we need some 5.6.0+ modules anyway
use vars qw($VERSION);
$VERSION=do { my @r=(q$Revision: 1.35 $=~/\d+/g); sprintf "%d.".("%03d"x$#r),@r; };
use strict;
use warnings;

use lib "./macros/";
use AutoGen;

use Carp qw(cluck confess);


AutoGen->run(
		"name"=>"captive",
		"COPYRIGHT_HOLDER"=>'Jan Kratochvil <project-captive@jankratochvil.net>',
		"ARGV"=>\@ARGV,
		"gtk-doc-dir"=>"./doc/apiref/",
		"clean"=>[qw(
				_include_test_false.c
				.include_test_all.stamp
				*.pod.pl *.pod *.[0-9]
				./ChangeLog.bak
				./debian/changelog
				./doc/*-pod.*
				./doc/apiref/gtk-doc.make
				./doc/apiref/gtk-doc.make-captive
				./fonts/fonts.conf
				./src/client/bug-replay/captive-bug-replay
				./src/client/cmdline/captive-cmdline
				./src/client/lufs/mount.captive
				./src/client/fuse/mount.captive
				./src/client/fuse/captive
				./src/client/fuse/captive-fusermount
				./src/client/sandbox-server/captive-sandbox-server
				./src/client/gnomevfs/captive.conf
				./src/install/fstab/captive-install-fstab
				./src/install/acquire/captive-install-acquire
				./src/install/acquire/ui-gnome-callbacks.[ch]
				./src/install/acquire/ui-gnome-interface.[ch]
				./src/install/acquire/ui-gnome-support.[ch]
				./src/install/acquire/ui-gnome.glade.bak
				./src/install/acquire/ui-gnome.gladep.bak
				./src/install/acquire/gnome_vfs_read_entire_file.c
				./src/libcaptive/cc/marshallers.[ch]
				./src/libcaptive/client/marshallers.[ch]
				./src/libcaptive/ke/exports.c
				./src/libcaptive/reactos/*/*.[cS]
				./src/libcaptive/sandbox/sandbox-common.c
				./src/libcaptive/sandbox/sandbox-skels.c
				./src/libcaptive/sandbox/sandbox-stubs.c
				./src/libcaptive/sandbox/sandbox.h
				./src/libcaptive/sandbox/sandbox-skelimpl.c
				./src/TraceFS/TraceFS-W32/obj
				./src/TraceFS/TraceFS-W32/objchk
				./src/TraceFS/TraceFS-W32/objfre
				./src/TraceFS/TraceFS-W32/buildchk.log
				./src/TraceFS/TraceFS-W32/buildchk.wrn
				./src/TraceFS/TraceFS-W32/buildchk.err
				./src/TraceFS/TraceFS-W32/buildfre.log
				./src/TraceFS/TraceFS-W32/buildfre.wrn
				./src/TraceFS/TraceFS-W32/buildfre.err
				)],
		"prep"=>sub {
				# For conflicting object basenames in convenient libraries:
				AutoGen->checkcommandversion("libtoolize","1.5");
				# 1.5 for AM_PROG_AS.
				# 1.6 to prevent weird error wrt 'SANDBOX_IDL_SOURCES':
				AutoGen->checkcommandversion("automake","1.6");

				AutoGen::_system "gtkdocize --copy --docdir doc/apiref/";
				for my $fname ("doc/apiref/gtk-doc.make") {
					my $gtk_doc_make=AutoGen::_readfile $fname;
					for my $keyword (qw(EXTRA_DIST CLEANFILES)) {
						$gtk_doc_make=~s/^$keyword =/$keyword +=/m or confess "$keyword not found in $fname";
						}
					$gtk_doc_make=~s/^(dist-hook): dist-check-gtkdoc (dist-hook-local)$/$1: $2\n\nDISABLED_$&/m;
					AutoGen::_writefile "$fname-captive",$gtk_doc_make;
					}
				for my $dir ("./src/install/acquire/cabextract") {
					if (!-f "$dir/cabextract.c" || -f "$dir/configure.in") {
						do { system $_ and die "$_: $!"; } for ("cvs update -kk -r captive $dir");
						}
					}
				1;
				},
		);
