dnl $Id: glade-w.m4,v 1.3 2005/12/29 03:00:58 lace Exp $
dnl autoconf plugin for 'glade-2 --write-source' detection
dnl Copyright (C) 2000,2003 Jan Kratochvil <project-macros@jankratochvil.net>
dnl 
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; exactly version 2 of June 1991 is required
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


dnl
dnl GLADE_W_INIT (glade-generated-files, user-option, add-on)
dnl
dnl glade-generated-files: All files that glade-w.sh.in would be able to
dnl                        generate. Depends on *.glade file options.
dnl user-option:           User wish for the client (yes/no/[* for auto])
dnl add-on:                Some additional requirements, set "glade_addon=yes"
dnl Use AC_SUBST(GNOMEUI_CFLAGS)
dnl     AC_SUBST(GNOMEUI_LIBS)
dnl afterwards.
dnl

AC_DEFUN([GLADE_W_INIT],
[
	if test "$2" != "no"
	then
		dnl Gnome is optional.
		PKG_CHECK_MODULES(GNOMEUI,libgnomeui-2.0,[
			AC_DEFINE(HAVE_GNOMEUI,,[Have libgnomeui-2.0 include files and libraries.])
			have_gnome=true 
			],[ have_gnome=false ])

		AC_PATH_PROG(PATH_GLADE,glade-2,)

dnl FIXME: Gnome-enabled glade-2 will complain on $DISPLAY even if --invalid-option!
dnl Do we need to provide Xvnc $DISPLAY to it to check it for Gnome support?
dnl Currently we assume it is Gnome-enabled.
dnl 		if test "x$PATH_GLADE" != "x"
dnl 		then
dnl 			AC_CACHE_CHECK([whether glade found has Gnome extensions],glade_cv_has_gnome,
dnl 				[
dnl 				save_DISPLAY="$DISPLAY"
dnl 				unset DISPLAY
dnl 				gladeun="`$PATH_GLADE --disable-crash-dialog --invalid-option 2>&1|grep -- '--invalid-option:'`"
dnl 				export DISPLAY="$save_DISPLAY"
dnl 				if test "x$gladeun" != "x"
dnl 				then
dnl 					glade_cv_has_gnome=yes
dnl 				else
dnl 					glade_cv_has_gnome=no
dnl 				fi
dnl 				])
dnl 			if test "x$glade_cv_has_gnome" = "xno"
dnl 			then
dnl 				unset PATH_GLADE
dnl 				AC_MSG_WARN([GTK+/Gnome: Glade builder was found but it has no Gnome support, only GTK+,
dnl 	please install Gnome packages and then recompile your Glade.])
dnl 			fi
dnl 		fi

		if test "x$PATH_GLADE" != "x"
		then
			AC_CACHE_CHECK([whether glade found is capable of write-source-ing],glade_cv_writesource,
				[
				save_DISPLAY="$DISPLAY"
				unset DISPLAY
				gladeun="`$PATH_GLADE --disable-crash-dialog --write-source /dev/null 2>&1|grep -- '-w:'`"
				export DISPLAY="$save_DISPLAY"
				if test "x$gladeun" = "x"
				then
					glade_cv_writesource=yes
				else
					glade_cv_writesource=no
				fi
				])
			if test "x$glade_cv_writesource" = "xno"
			then
				unset PATH_GLADE
				AC_MSG_WARN([GTK+/Gnome: Glade builder was found but it is not capable of batch source builds,
	please upgrade to Glade version 0.5.8 or higher.])
			fi
		fi

		if test "x$PATH_GLADE" != "x"
		then
			AC_PATH_PROG(PATH_XVNC,Xvnc,)
			AC_PATH_PROG(PATH_BC,bc,)
			AC_CACHE_CHECK([whether it is possible to access any X server for Glade],glade_cv_can_xserver,
				[
				export PATH_XVNC
				export PATH_BC
				gladeun="`sh $srcdir/macros/glade-w.sh.in /dev/null 2>&1|grep -- 'Document is empty'`"
				if test "x$gladeun" != "x"
				then
					glade_cv_can_xserver=yes
				else
					glade_cv_can_xserver=no
				fi
				])
			if test "x$glade_cv_can_xserver" = "xno"
			then
				unset PATH_GLADE
				if test "x$PATH_XVNC" = "x"
				then
					AC_MSG_WARN([GTK+/Gnome: Unable to access any valid X server, give DISPLAY or install Xvnc(1) (vnc-server package).])
				else
					AC_MSG_WARN([GTK+/Gnome: Unable to access any valid X server, DISPLAY and Xvnc(1) tried.])
				fi
			fi
		fi

		AC_MSG_CHECKING(whether I need write-source-ing and runnable Glade for GTK+/Gnome client)
		NEED_GLADE=no
		if test "x$1" = "x"
		then
			gnofis="./src/interface.c ./src/interface.h ./src/support.c ./src/support.h"
		else
			gnofis="$1"
		fi
		for gnofi in $gnofis
		do
			if test '!' -f "$gnofi"
			then
				NEED_GLADE=yes
			fi
		done
		AC_MSG_RESULT($NEED_GLADE)

		glade_addon=no
		ifelse([$3], ,glade_addon=yes,[$3])
	fi

	if test "x$2" != "xno" -a "xtrue" = "x$have_gnome" -a '(' "x$NEED_GLADE" = "xno" -o "x$PATH_GLADE" != "x" ')' -a "x$glade_addon" = "xyes"
	then
		BUILD_GLADESRC=yes
	else
		BUILD_GLADESRC=no
		if test "x$2" = "xyes"
		then
			AC_MSG_ERROR([GTK+/Gnome: Requested client compilation impossible, see errors above.])
		elif test "x$2" != "xno"
		then
			AC_MSG_WARN([GTK+/Gnome: Interface will not be build, see errors above for reason(s).])
		fi
	fi
	AM_CONDITIONAL(HAVE_GLADE_WRITESOURCE,[ test "x$PATH_GLADE" != "x" ])
	AM_CONDITIONAL(BUILD_GLADESRC,[ test "xyes" = "x$BUILD_GLADESRC" ])
])
