/* Mouse definitions common to both mouse class and port drivers */

#define DD_MOUSE_DEVICE_NAME	"\\Device\\PointerClass"
#define DD_MOUSE_DEVICE_NAME_U	L"\\Device\\PointerClass"

#define IO_MOUSE_INCREMENT	6
#define MOUSE_BUFFER_SIZE	32

#define IOCTL_INTERNAL_MOUSE_CONNECT	CTL_CODE(FILE_DEVICE_MOUSE, 0x0080, METHOD_NEITHER, FILE_ANY_ACCESS)
#define IOCTL_INTERNAL_MOUSE_DISCONNECT	CTL_CODE(FILE_DEVICE_MOUSE, 0x0100, METHOD_NEITHER, FILE_ANY_ACCESS)
#define IOCTL_INTERNAL_MOUSE_ENABLE 	CTL_CODE(FILE_DEVICE_MOUSE, 0x0200, METHOD_NEITHER, FILE_ANY_ACCESS)
#define IOCTL_INTERNAL_MOUSE_DISABLE	CTL_CODE(FILE_DEVICE_MOUSE, 0x0400, METHOD_NEITHER, FILE_ANY_ACCESS)

#define IOCTL_MOUSE_QUERY_ATTRIBUTES	CTL_CODE(FILE_DEVICE_MOUSE, 0x0000, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define MOUSE_BUTTON_1_DOWN  0x0001
#define MOUSE_BUTTON_1_UP    0x0002
#define MOUSE_BUTTON_2_DOWN  0x0004
#define MOUSE_BUTTON_2_UP    0x0008
#define MOUSE_BUTTON_3_DOWN  0x0010
#define MOUSE_BUTTON_3_UP    0x0020
#define MOUSE_BUTTON_4_DOWN  0x0040
#define MOUSE_BUTTON_4_UP    0x0080
#define MOUSE_BUTTON_5_DOWN  0x0100
#define MOUSE_BUTTON_5_UP    0x0200
#define MOUSE_WHEEL          0x0400

#define MOUSE_LEFT_BUTTON_DOWN    MOUSE_BUTTON_1_DOWN
#define MOUSE_LEFT_BUTTON_UP      MOUSE_BUTTON_1_UP
#define MOUSE_RIGHT_BUTTON_DOWN   MOUSE_BUTTON_2_DOWN
#define MOUSE_RIGHT_BUTTON_UP     MOUSE_BUTTON_2_UP
#define MOUSE_MIDDLE_BUTTON_DOWN  MOUSE_BUTTON_3_DOWN
#define MOUSE_MIDDLE_BUTTON_UP    MOUSE_BUTTON_3_UP

#define MOUSE_SERIAL_HARDWARE		0x0004
#define WHEELMOUSE_SERIAL_HARDWARE	0x0040

typedef struct _MOUSE_ATTRIBUTES {
	USHORT MouseIdentifier;
	USHORT NumberOfButtons;
	USHORT SampleRate;
	ULONG InputDataQueueLength;
} MOUSE_ATTRIBUTES, *PMOUSE_ATTRIBUTES;

/* Mouse input data structure */
typedef struct _MOUSE_INPUT_DATA {
	USHORT UnitId;
	USHORT Flags;
	union {
		ULONG Buttons;
		struct  {
			USHORT  ButtonFlags;
			USHORT  ButtonData;
		};
	};
	ULONG RawButtons;
	LONG LastX;
	LONG LastY;
	ULONG ExtraInformation;
} MOUSE_INPUT_DATA, *PMOUSE_INPUT_DATA;

typedef struct _CLASS_INFORMATION {
   PDEVICE_OBJECT DeviceObject;
   PVOID CallBack;
} CLASS_INFORMATION, *PCLASS_INFORMATION;

typedef struct _GDI_INFORMATION {
   PVOID CallBack;
} GDI_INFORMATION, *PGDI_INFORMATION;

typedef
VOID
(*PSERVICE_CALLBACK_ROUTINE) (
    IN PVOID NormalContext,
    IN PVOID SystemArgument1,
    IN PVOID SystemArgument2,
    IN OUT PVOID SystemArgument3
    );

typedef
VOID
(*PGDI_SERVICE_CALLBACK_ROUTINE) (
    IN PVOID SystemArgument1,
    IN ULONG SystemArgument2
    );

