/* $Id$
 *
 * COPYRIGHT:       See COPYING in the top level directory
 * PROJECT:         ReactOS kernel
 * FILE:            services/storage/include/ntddscsi.h
 * PURPOSE:         Basic SCSI definitions
 * PROGRAMMER:      Eric Kohl (ekohl@rz-online.de)
 */

#ifndef __STORAGE_INCLUDE_NTDDSCSI_H
#define __STORAGE_INCLUDE_NTDDSCSI_H

/* IOCTL codes */
#define IOCTL_SCSI_PASS_THROUGH \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0401, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_SCSI_MINIPORT \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0402, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_SCSI_GET_INQUIRY_DATA \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0403, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SCSI_GET_CAPABILITIES \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0404, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SCSI_PASS_THROUGH_DIRECT \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0405, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_SCSI_GET_ADDRESS \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0406, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SCSI_RESCAN_BUS \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0407, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SCSI_GET_DUMP_POINTERS \
	CTL_CODE(FILE_DEVICE_CONTROLLER, 0x0408, METHOD_BUFFERED, FILE_ANY_ACCESS)



/* Used by IOCTL_SCSI_GET_CAPABILITIES */

typedef struct _IO_SCSI_CAPABILITIES
{
  ULONG Length;
  ULONG MaximumTransferLength;
  ULONG MaximumPhysicalPages;
  ULONG SupportedAsynchronousEvents;
  ULONG AlignmentMask;
  BOOLEAN TaggedQueuing;
  BOOLEAN AdapterScansDown;
  BOOLEAN AdapterUsesPio;
} IO_SCSI_CAPABILITIES, *PIO_SCSI_CAPABILITIES;


/* Used by IOCTL_SCSI_GET_INQUIRY_DATA */

typedef struct _SCSI_BUS_DATA
{
  UCHAR NumberOfLogicalUnits;
  UCHAR InitiatorBusId;
  ULONG InquiryDataOffset;
}SCSI_BUS_DATA, *PSCSI_BUS_DATA;


typedef struct _SCSI_ADAPTER_BUS_INFO
{
  UCHAR NumberOfBuses;
  SCSI_BUS_DATA BusData[1];
} SCSI_ADAPTER_BUS_INFO, *PSCSI_ADAPTER_BUS_INFO;


typedef struct _SCSI_INQUIRY_DATA
{
  UCHAR PathId;
  UCHAR TargetId;
  UCHAR Lun;
  BOOLEAN DeviceClaimed;
  ULONG InquiryDataLength;
  ULONG NextInquiryDataOffset;
  UCHAR InquiryData[1];
}SCSI_INQUIRY_DATA, *PSCSI_INQUIRY_DATA;


/* Used by IOCTL_SCSI_GET_ADDRESS */

typedef struct _SCSI_ADDRESS
{
  ULONG Length;
  UCHAR PortNumber;
  UCHAR PathId;
  UCHAR TargetId;
  UCHAR Lun;
} SCSI_ADDRESS, *PSCSI_ADDRESS;


/* Used by IOCTL_SCSI_PASS_THROUGH */

typedef struct _SCSI_PASS_THROUGH
{
  USHORT Length;
  UCHAR ScsiStatus;
  UCHAR PathId;
  UCHAR TargetId;
  UCHAR Lun;
  UCHAR CdbLength;
  UCHAR SenseInfoLength;
  UCHAR DataIn;
  ULONG DataTransferLength;
  ULONG TimeOutValue;
  ULONG DataBufferOffset;
  ULONG SenseInfoOffset;
  UCHAR Cdb[16];
} SCSI_PASS_THROUGH, *PSCSI_PASS_THROUGH;


/* Used by IOCTL_SCSI_PASS_THROUGH_DIRECT */

typedef struct _SCSI_PASS_THROUGH_DIRECT
{
  USHORT Length;
  UCHAR ScsiStatus;
  UCHAR PathId;
  UCHAR TargetId;
  UCHAR Lun;
  UCHAR CdbLength;
  UCHAR SenseInfoLength;
  UCHAR DataIn;
  ULONG DataTransferLength;
  ULONG TimeOutValue;
  ULONG DataBufferOffset;
  ULONG SenseInfoOffset;
  UCHAR Cdb[16];
} SCSI_PASS_THROUGH_DIRECT, *PSCSI_PASS_THROUGH_DIRECT;


/* Pass through DataIn */

#define SCSI_IOCTL_DATA_OUT		0
#define SCSI_IOCTL_DATA_IN		1
#define SCSI_IOCTL_DATA_UNSPECIFIED	2

typedef struct _DUMP_POINTERS
{
  PVOID DeviceObject;
} DUMP_POINTERS, *PDUMP_POINTERS;

#endif /* __STORAGE_INCLUDE_NTDDSCSI_H */

/* EOF */
