#ifdef __USE_W32API

#include_next <ddk/ntifs.h>

#else /* __USE_W32API */

#ifndef __INCLUDE_DDK_NTIFS_H
#define __INCLUDE_DDK_NTIFS_H

NTSTATUS STDCALL
CcRosInitializeFileCache (PFILE_OBJECT	FileObject,
		          ULONG		CacheSegmentSize);
NTSTATUS STDCALL
CcRosReleaseFileCache (PFILE_OBJECT	FileObject);

#define FSCTL_ROS_QUERY_LCN_MAPPING \
        CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS)

typedef struct _ROS_QUERY_LCN_MAPPING
{
  LARGE_INTEGER LcnDiskOffset;
} ROS_QUERY_LCN_MAPPING, *PROS_QUERY_LCN_MAPPING;

#include <ddk/cctypes.h>

#include <ddk/ccfuncs.h>

#include <ddk/fstypes.h>
#include <ddk/fsfuncs.h>

//  This Fcb header is used for files which support caching
//  of compressed data, and related new support.

typedef struct _FSRTL_ADVANCED_FCB_HEADER
{
    FSRTL_COMMON_FCB_HEADER common_fcb_header;

    //  The following two fields are supported only if
    //  Flags2 contains FSRTL_FLAG2_SUPPORTS_FILTER_CONTEXTS
    //
    //  This is a pointer to a Fast Mutex which may be used to
    //  properly synchronize access to the FsRtl header.  The
    //  Fast Mutex must be nonpaged.
    PFAST_MUTEX FastMutex;

    // This is a pointer to a list of context structures belonging to
    // filesystem filter drivers that are linked above the filesystem.
    // Each structure is headed by FSRTL_FILTER_CONTEXT.
    LIST_ENTRY FilterContexts;
} FSRTL_ADVANCED_FCB_HEADER;
typedef FSRTL_ADVANCED_FCB_HEADER *PFSRTL_ADVANCED_FCB_HEADER;

#endif /* __INCLUDE_DDK_NTIFS_H */

#endif /* __USE_W32API */
