#ifndef __INCLUDE_DDK_STATUS_H
#define __INCLUDE_DDK_STATUS_H

#ifndef __ASM__

#ifndef LIBCAPTIVE
#define NT_SUCCESS(StatCode)  ((NTSTATUS)(StatCode) >= 0)
#else /* !LIBCAPTIVE */
/* Never pass through 'STATUS_PENDING' and we are generally more strict anyway */
#define NT_SUCCESS(StatCode)  ((NTSTATUS)(StatCode)==STATUS_SUCCESS)
#endif /* !LIBCAPTIVE */

/*
 * Possible status codes
 * FIXME: These may not be the actual values used by NT
 * Retype to (NTSTATUS) to prevent "warning: comparison between signed and unsigned"
 * on >=0x80000000 status code values comparations
 */

#define STATUS_SUCCESS                              ((NTSTATUS)0x00000000)
#ifndef STATUS_WAIT_0
#define STATUS_WAIT_0                               ((NTSTATUS)0x00000000)
#endif
#define STATUS_WAIT_63                              ((NTSTATUS)0x0000003F)
#define STATUS_ABANDONED                            ((NTSTATUS)0x00000080)
#ifndef STATUS_ABANDONED_WAIT_0
#define STATUS_ABANDONED_WAIT_0                     ((NTSTATUS)0x00000080)
#endif
#define STATUS_ABANDONED_WAIT_63                    ((NTSTATUS)0x000000BF)
#ifndef STATUS_USER_APC
#define STATUS_USER_APC                             ((NTSTATUS)0x000000C0)
#endif
#define STATUS_KERNEL_APC                           ((NTSTATUS)0x00000100)
#define STATUS_ALERTED                              ((NTSTATUS)0x00000101)
#ifndef STATUS_TIMEOUT
#define STATUS_TIMEOUT                              ((NTSTATUS)0x00000102)
#endif
#ifndef STATUS_PENDING
#define STATUS_PENDING                              ((NTSTATUS)0x00000103)
#endif
#define STATUS_REPARSE                              ((NTSTATUS)0x00000104)
#define STATUS_MORE_ENTRIES                         ((NTSTATUS)0x00000105)
#define STATUS_NOT_ALL_ASSIGNED                     ((NTSTATUS)0x00000106)
#define STATUS_SOME_NOT_MAPPED                      ((NTSTATUS)0x00000107)
#define STATUS_OPLOCK_BREAK_IN_PROCESS              ((NTSTATUS)0x00000108)
#define STATUS_VOLUME_MOUNTED                       ((NTSTATUS)0x00000109)
#define STATUS_RXACT_COMMITTED                      ((NTSTATUS)0x0000010A)
#define STATUS_NOTIFY_CLEANUP                       ((NTSTATUS)0x0000010B)
#define STATUS_NOTIFY_ENUM_DIR                      ((NTSTATUS)0x0000010C)
#define STATUS_NO_QUOTAS_NO_ACCOUNT                 ((NTSTATUS)0x0000010D)
#define STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED     ((NTSTATUS)0x0000010E)

#define STATUS_OBJECT_EXISTS                        ((NTSTATUS)0x40000000)
#define STATUS_THREAD_WAS_SUSPENDED                 ((NTSTATUS)0x40000001)
#define STATUS_WORKING_SET_LIMIT_RANGE              ((NTSTATUS)0x40000002)
#define STATUS_IMAGE_NOT_AT_BASE                    ((NTSTATUS)0x40000003)
#define STATUS_RXACT_STATE_CREATED                  ((NTSTATUS)0x40000004)
#define STATUS_SEGMENT_NOTIFICATION                 ((NTSTATUS)0x40000005)
#define STATUS_LOCAL_USER_SESSION_KEY               ((NTSTATUS)0x40000006)
#define STATUS_BAD_CURRENT_DIRECTORY                ((NTSTATUS)0x40000007)
#define STATUS_SERIAL_MORE_WRITES                   ((NTSTATUS)0x40000008)
#define STATUS_REGISTRY_RECOVERED                   ((NTSTATUS)0x40000009)
#define STATUS_FT_READ_RECOVERING_FROM_BACKUP       ((NTSTATUS)0x4000000A)
#define STATUS_FT_WRITE_RECOVERY                    ((NTSTATUS)0x4000000B)
#define STATUS_SERIAL_COUNTER_TIMEOUT               ((NTSTATUS)0x4000000C)
#define STATUS_NULL_LM_PASSWORD                     ((NTSTATUS)0x4000000D)
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH          ((NTSTATUS)0x4000000E)
#define STATUS_RECEIVE_PARTIAL                      ((NTSTATUS)0x4000000F)
#define STATUS_RECEIVE_EXPEDITED                    ((NTSTATUS)0x40000010)
#define STATUS_RECEIVE_PARTIAL_EXPEDITED            ((NTSTATUS)0x40000011)
#define STATUS_EVENT_DONE                           ((NTSTATUS)0x40000012)
#define STATUS_EVENT_PENDING                        ((NTSTATUS)0x40000013)
#define STATUS_CHECKING_FILE_SYSTEM                 ((NTSTATUS)0x40000014)
#define STATUS_FATAL_APP_EXIT                       ((NTSTATUS)0x40000015)
#define STATUS_PREDEFINED_HANDLE                    ((NTSTATUS)0x40000016)
#define STATUS_WAS_UNLOCKED                         ((NTSTATUS)0x40000017)
#define STATUS_SERVICE_NOTIFICATION                 ((NTSTATUS)0x40000018)
#define STATUS_WAS_LOCKED                           ((NTSTATUS)0x40000019)
#define STATUS_LOG_HARD_ERROR                       ((NTSTATUS)0x4000001A)
#define STATUS_ALREADY_WIN32                        ((NTSTATUS)0x4000001B)
#define STATUS_WX86_UNSIMULATE                      ((NTSTATUS)0x4000001C)
#define STATUS_WX86_CONTINUE                        ((NTSTATUS)0x4000001D)
#define STATUS_WX86_SINGLE_STEP                     ((NTSTATUS)0x4000001E)
#define STATUS_WX86_BREAKPOINT                      ((NTSTATUS)0x4000001F)
#define STATUS_WX86_EXCEPTION_CONTINUE              ((NTSTATUS)0x40000020)
#define STATUS_WX86_EXCEPTION_LASTCHANCE            ((NTSTATUS)0x40000021)
#define STATUS_WX86_EXCEPTION_CHAIN                 ((NTSTATUS)0x40000022)
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE      ((NTSTATUS)0x40000023)
#define STATUS_NO_YIELD_PERFORMED                   ((NTSTATUS)0x40000024)
#define STATUS_TIMER_RESUME_IGNORED                 ((NTSTATUS)0x40000025)
#define STATUS_ARBITRATION_UNHANDLED                ((NTSTATUS)0x40000026)
#define STATUS_CARDBUS_NOT_SUPPORTED                ((NTSTATUS)0x40000027)
#define STATUS_WX86_CREATEWX86TIB                   ((NTSTATUS)0x40000028)

#define STATUS_GUARD_PAGE_VIOLATION                 ((NTSTATUS)0x80000001)
#define STATUS_DATATYPE_MISALIGNMENT                ((NTSTATUS)0x80000002)
#define STATUS_BREAKPOINT                           ((NTSTATUS)0x80000003)
#define STATUS_SINGLE_STEP                          ((NTSTATUS)0x80000004)
#define STATUS_BUFFER_OVERFLOW                      ((NTSTATUS)0x80000005)
#define STATUS_NO_MORE_FILES                        ((NTSTATUS)0x80000006)
#define STATUS_WAKE_SYSTEM_DEBUGGER                 ((NTSTATUS)0x80000007)

#define STATUS_HANDLES_CLOSED                       ((NTSTATUS)0x8000000A)
#define STATUS_NO_INHERITANCE                       ((NTSTATUS)0x8000000B)
#define STATUS_GUID_SUBSTITUTION_MADE               ((NTSTATUS)0x8000000C)
#define STATUS_PARTIAL_COPY                         ((NTSTATUS)0x8000000D)
#define STATUS_DEVICE_PAPER_EMPTY                   ((NTSTATUS)0x8000000E)
#define STATUS_DEVICE_POWERED_OFF                   ((NTSTATUS)0x8000000F)
#define STATUS_DEVICE_OFF_LINE                      ((NTSTATUS)0x80000010)
#define STATUS_DEVICE_BUSY                          ((NTSTATUS)0x80000011)
#define STATUS_NO_MORE_EAS                          ((NTSTATUS)0x80000012)
#define STATUS_INVALID_EA_NAME                      ((NTSTATUS)0x80000013)
#define STATUS_EA_LIST_INCONSISTENT                 ((NTSTATUS)0x80000014)
#define STATUS_INVALID_EA_FLAG                      ((NTSTATUS)0x80000015)
#define STATUS_VERIFY_REQUIRED                      ((NTSTATUS)0x80000016)
#define STATUS_EXTRANEOUS_INFORMATION               ((NTSTATUS)0x80000017)
#define STATUS_RXACT_COMMIT_NECESSARY               ((NTSTATUS)0x80000018)

#define STATUS_NO_MORE_ENTRIES                      ((NTSTATUS)0x8000001A)
#define STATUS_FILEMARK_DETECTED                    ((NTSTATUS)0x8000001B)
#define STATUS_MEDIA_CHANGED                        ((NTSTATUS)0x8000001C)
#define STATUS_BUS_RESET                            ((NTSTATUS)0x8000001D)
#define STATUS_END_OF_MEDIA                         ((NTSTATUS)0x8000001E)
#define STATUS_BEGINNING_OF_MEDIA                   ((NTSTATUS)0x8000001F)
#define STATUS_MEDIA_CHECK                          ((NTSTATUS)0x80000020)
#define STATUS_SETMARK_DETECTED                     ((NTSTATUS)0x80000021)
#define STATUS_NO_DATA_DETECTED                     ((NTSTATUS)0x80000022)
#define STATUS_REDIRECTOR_HAS_OPEN_HANDLES          ((NTSTATUS)0x80000023)
#define STATUS_SERVER_HAS_OPEN_HANDLES              ((NTSTATUS)0x80000024)
#define STATUS_ALREADY_DISCONNECTED                 ((NTSTATUS)0x80000025)
#define STATUS_LONGJUMP                             ((NTSTATUS)0x80000026)

#define STATUS_UNSUCCESSFUL                         ((NTSTATUS)0xc0000001)
#define STATUS_NOT_IMPLEMENTED                      ((NTSTATUS)0xc0000002)
#define STATUS_INVALID_INFO_CLASS                   ((NTSTATUS)0xc0000003)
#define STATUS_INFO_LENGTH_MISMATCH                 ((NTSTATUS)0xc0000004)
#define STATUS_ACCESS_VIOLATION                     ((NTSTATUS)0xc0000005)
#define STATUS_IN_PAGE_ERROR                        ((NTSTATUS)0xc0000006)
#define STATUS_PAGEFILE_QUOTA                       ((NTSTATUS)0xc0000007)
#define STATUS_INVALID_HANDLE                       ((NTSTATUS)0xc0000008)
#define STATUS_BAD_INITIAL_STACK                    ((NTSTATUS)0xc0000009)
#define STATUS_BAD_INITIAL_PC                       ((NTSTATUS)0xc000000a)
#define STATUS_INVALID_CID                          ((NTSTATUS)0xc000000b)
#define STATUS_TIMER_NOT_CANCELED                   ((NTSTATUS)0xc000000c)
#define STATUS_INVALID_PARAMETER                    ((NTSTATUS)0xc000000d)
#define STATUS_NO_SUCH_DEVICE                       ((NTSTATUS)0xc000000e)
#define STATUS_NO_SUCH_FILE                         ((NTSTATUS)0xc000000f)
#define STATUS_INVALID_DEVICE_REQUEST               ((NTSTATUS)0xc0000010)
#define STATUS_END_OF_FILE                          ((NTSTATUS)0xc0000011)
#define STATUS_WRONG_VOLUME                         ((NTSTATUS)0xc0000012)
#define STATUS_NO_MEDIA_IN_DEVICE                   ((NTSTATUS)0xc0000013)
#define STATUS_UNRECOGNIZED_MEDIA                   ((NTSTATUS)0xc0000014)
#define STATUS_NONEXISTENT_SECTOR                   ((NTSTATUS)0xc0000015)
#define STATUS_MORE_PROCESSING_REQUIRED             ((NTSTATUS)0xc0000016)
#define STATUS_NO_MEMORY                            ((NTSTATUS)0xc0000017)
#define STATUS_CONFLICTING_ADDRESSES                ((NTSTATUS)0xc0000018)
#define STATUS_NOT_MAPPED_VIEW                      ((NTSTATUS)0xc0000019)
#define STATUS_UNABLE_TO_FREE_VM                    ((NTSTATUS)0xc000001a)
#define STATUS_UNABLE_TO_DELETE_SECTION             ((NTSTATUS)0xc000001b)
#define STATUS_INVALID_SYSTEM_SERVICE               ((NTSTATUS)0xc000001c)
#define STATUS_ILLEGAL_INSTRUCTION                  ((NTSTATUS)0xc000001d)
#define STATUS_INVALID_LOCK_SEQUENCE                ((NTSTATUS)0xc000001e)
#define STATUS_INVALID_VIEW_SIZE                    ((NTSTATUS)0xc000001f)
#define STATUS_INVALID_FILE_FOR_SECTION             ((NTSTATUS)0xc0000020)
#define STATUS_ALREADY_COMMITTED                    ((NTSTATUS)0xc0000021)
#define STATUS_ACCESS_DENIED                        ((NTSTATUS)0xc0000022)
#define STATUS_BUFFER_TOO_SMALL                     ((NTSTATUS)0xc0000023)
#define STATUS_OBJECT_TYPE_MISMATCH                 ((NTSTATUS)0xc0000024)
#define STATUS_NONCONTINUABLE_EXCEPTION             ((NTSTATUS)0xc0000025)
#define STATUS_INVALID_DISPOSITION                  ((NTSTATUS)0xc0000026)
#define STATUS_UNWIND                               ((NTSTATUS)0xc0000027)
#define STATUS_BAD_STACK                            ((NTSTATUS)0xc0000028)
#define STATUS_INVALID_UNWIND_TARGET                ((NTSTATUS)0xc0000029)
#define STATUS_NOT_LOCKED                           ((NTSTATUS)0xc000002a)
#define STATUS_PARITY_ERROR                         ((NTSTATUS)0xc000002b)
#define STATUS_UNABLE_TO_DECOMMIT_VM                ((NTSTATUS)0xc000002c)
#define STATUS_NOT_COMMITTED                        ((NTSTATUS)0xc000002d)
#define STATUS_INVALID_PORT_ATTRIBUTES              ((NTSTATUS)0xc000002e)
#define STATUS_PORT_MESSAGE_TOO_LONG                ((NTSTATUS)0xc000002f)
#define STATUS_INVALID_PARAMETER_MIX                ((NTSTATUS)0xc0000030)
#define STATUS_INVALID_QUOTA_LOWER                  ((NTSTATUS)0xc0000031)
#define STATUS_DISK_CORRUPT_ERROR                   ((NTSTATUS)0xc0000032)
#define STATUS_OBJECT_NAME_INVALID                  ((NTSTATUS)0xc0000033)
#define STATUS_OBJECT_NAME_NOT_FOUND                ((NTSTATUS)0xc0000034)
#define STATUS_OBJECT_NAME_COLLISION                ((NTSTATUS)0xc0000035)
#define STATUS_OBJECT_NAME_EXISTS                   ((NTSTATUS)0x40000000)


#define STATUS_PORT_DISCONNECTED                    ((NTSTATUS)0xc0000037)
#define STATUS_DEVICE_ALREADY_ATTACHED              ((NTSTATUS)0xc0000038)
#define STATUS_OBJECT_PATH_INVALID                  ((NTSTATUS)0xc0000039)
#define STATUS_OBJECT_PATH_NOT_FOUND                ((NTSTATUS)0xc000003a)
#define STATUS_OBJECT_PATH_SYNTAX_BAD               ((NTSTATUS)0xc000003b)
#define STATUS_DATA_OVERRUN                         ((NTSTATUS)0xc000003c)
#define STATUS_DATA_LATE_ERROR                      ((NTSTATUS)0xc000003d)
#define STATUS_DATA_ERROR                           ((NTSTATUS)0xc000003e)
#define STATUS_CRC_ERROR                            ((NTSTATUS)0xc000003f)
#define STATUS_SECTION_TOO_BIG                      ((NTSTATUS)0xc0000040)
#define STATUS_PORT_CONNECTION_REFUSED              ((NTSTATUS)0xc0000041)
#define STATUS_INVALID_PORT_HANDLE                  ((NTSTATUS)0xc0000042)
#define STATUS_SHARING_VIOLATION                    ((NTSTATUS)0xc0000043)
#define STATUS_QUOTA_EXCEEDED                       ((NTSTATUS)0xc0000044)
#define STATUS_INVALID_PAGE_PROTECTION              ((NTSTATUS)0xc0000045)
#define STATUS_MUTANT_NOT_OWNED                     ((NTSTATUS)0xc0000046)
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED             ((NTSTATUS)0xc0000047)
#define STATUS_PORT_ALREADY_SET                     ((NTSTATUS)0xc0000048)
#define STATUS_SECTION_NOT_IMAGE                    ((NTSTATUS)0xc0000049)
#define STATUS_SUSPEND_COUNT_EXCEEDED               ((NTSTATUS)0xc000004a)
#define STATUS_THREAD_IS_TERMINATING                ((NTSTATUS)0xc000004b)
#define STATUS_BAD_WORKING_SET_LIMIT                ((NTSTATUS)0xc000004c)
#define STATUS_INCOMPATIBLE_FILE_MAP                ((NTSTATUS)0xc000004d)
#define STATUS_SECTION_PROTECTION                   ((NTSTATUS)0xc000004e)
#define STATUS_EAS_NOT_SUPPORTED                    ((NTSTATUS)0xc000004f)
#define STATUS_EA_TOO_LARGE                         ((NTSTATUS)0xc0000050)
#define STATUS_NONEXISTENT_EA_ENTRY                 ((NTSTATUS)0xc0000051)
#define STATUS_NO_EAS_ON_FILE                       ((NTSTATUS)0xc0000052)
#define STATUS_EA_CORRUPT_ERROR                     ((NTSTATUS)0xc0000053)
#define STATUS_FILE_LOCK_CONFLICT                   ((NTSTATUS)0xc0000054)
#define STATUS_LOCK_NOT_GRANTED                     ((NTSTATUS)0xc0000055)
#define STATUS_DELETE_PENDING                       ((NTSTATUS)0xc0000056)
#define STATUS_CTL_FILE_NOT_SUPPORTED               ((NTSTATUS)0xc0000057)
#define STATUS_UNKNOWN_REVISION                     ((NTSTATUS)0xc0000058)
#define STATUS_REVISION_MISMATCH                    ((NTSTATUS)0xc0000059)
#define STATUS_INVALID_OWNER                        ((NTSTATUS)0xc000005a)
#define STATUS_INVALID_PRIMARY_GROUP                ((NTSTATUS)0xc000005b)
#define STATUS_NO_IMPERSONATION_TOKEN               ((NTSTATUS)0xc000005c)
#define STATUS_CANT_DISABLE_MANDATORY               ((NTSTATUS)0xc000005d)
#define STATUS_NO_LOGON_SERVERS                     ((NTSTATUS)0xc000005e)
#define STATUS_NO_SUCH_LOGON_SESSION                ((NTSTATUS)0xc000005f)
#define STATUS_NO_SUCH_PRIVILEGE                    ((NTSTATUS)0xc0000060)
#define STATUS_PRIVILEGE_NOT_HELD                   ((NTSTATUS)0xc0000061)
#define STATUS_INVALID_ACCOUNT_NAME                 ((NTSTATUS)0xc0000062)
#define STATUS_USER_EXISTS                          ((NTSTATUS)0xc0000063)
#define STATUS_NO_SUCH_USER                         ((NTSTATUS)0xc0000064)
#define STATUS_GROUP_EXISTS                         ((NTSTATUS)0xc0000065)
#define STATUS_NO_SUCH_GROUP                        ((NTSTATUS)0xc0000066)
#define STATUS_MEMBER_IN_GROUP                      ((NTSTATUS)0xc0000067)
#define STATUS_MEMBER_NOT_IN_GROUP                  ((NTSTATUS)0xc0000068)
#define STATUS_LAST_ADMIN                           ((NTSTATUS)0xc0000069)
#define STATUS_WRONG_PASSWORD                       ((NTSTATUS)0xc000006a)
#define STATUS_ILL_FORMED_PASSWORD                  ((NTSTATUS)0xc000006b)
#define STATUS_PASSWORD_RESTRICTION                 ((NTSTATUS)0xc000006c)
#define STATUS_LOGON_FAILURE                        ((NTSTATUS)0xc000006d)
#define STATUS_ACCOUNT_RESTRICTION                  ((NTSTATUS)0xc000006e)
#define STATUS_INVALID_LOGON_HOURS                  ((NTSTATUS)0xc000006f)
#define STATUS_INVALID_WORKSTATION                  ((NTSTATUS)0xc0000070)
#define STATUS_PASSWORD_EXPIRED                     ((NTSTATUS)0xc0000071)
#define STATUS_ACCOUNT_DISABLED                     ((NTSTATUS)0xc0000072)
#define STATUS_NONE_MAPPED                          ((NTSTATUS)0xc0000073)
#define STATUS_TOO_MANY_LUIDS_REQUESTED             ((NTSTATUS)0xc0000074)
#define STATUS_LUIDS_EXHAUSTED                      ((NTSTATUS)0xc0000075)
#define STATUS_INVALID_SUB_AUTHORITY                ((NTSTATUS)0xc0000076)
#define STATUS_INVALID_ACL                          ((NTSTATUS)0xc0000077)
#define STATUS_INVALID_SID                          ((NTSTATUS)0xc0000078)
#define STATUS_INVALID_SECURITY_DESCR               ((NTSTATUS)0xc0000079)
#define STATUS_PROCEDURE_NOT_FOUND                  ((NTSTATUS)0xc000007a)
#define STATUS_INVALID_IMAGE_FORMAT                 ((NTSTATUS)0xc000007b)
#define STATUS_NO_TOKEN                             ((NTSTATUS)0xc000007c)
#define STATUS_BAD_INHERITANCE_ACL                  ((NTSTATUS)0xc000007d)
#define STATUS_RANGE_NOT_LOCKED                     ((NTSTATUS)0xc000007e)
#define STATUS_DISK_FULL                            ((NTSTATUS)0xc000007f)
#define STATUS_SERVER_DISABLED                      ((NTSTATUS)0xc0000080)
#define STATUS_SERVER_NOT_DISABLED                  ((NTSTATUS)0xc0000081)
#define STATUS_TOO_MANY_GUIDS_REQUESTED             ((NTSTATUS)0xc0000082)
#define STATUS_GUIDS_EXHAUSTED                      ((NTSTATUS)0xc0000083)
#define STATUS_INVALID_ID_AUTHORITY                 ((NTSTATUS)0xc0000084)
#define STATUS_AGENTS_EXHAUSTED                     ((NTSTATUS)0xc0000085)
#define STATUS_INVALID_VOLUME_LABEL                 ((NTSTATUS)0xc0000086)
#define STATUS_SECTION_NOT_EXTENDED                 ((NTSTATUS)0xc0000087)
#define STATUS_NOT_MAPPED_DATA                      ((NTSTATUS)0xc0000088)
#define STATUS_RESOURCE_DATA_NOT_FOUND              ((NTSTATUS)0xc0000089)
#define STATUS_RESOURCE_TYPE_NOT_FOUND              ((NTSTATUS)0xc000008a)
#define STATUS_RESOURCE_NAME_NOT_FOUND              ((NTSTATUS)0xc000008b)
#define STATUS_ARRAY_BOUNDS_EXCEEDED                ((NTSTATUS)0xc000008c)
#define STATUS_FLOAT_DENORMAL_OPERAND               ((NTSTATUS)0xc000008d)
#define STATUS_FLOAT_DIVIDE_BY_ZERO                 ((NTSTATUS)0xc000008e)
#define STATUS_FLOAT_INEXACT_RESULT                 ((NTSTATUS)0xc000008f)
#define STATUS_FLOAT_INVALID_OPERATION              ((NTSTATUS)0xc0000090)
#define STATUS_FLOAT_OVERFLOW                       ((NTSTATUS)0xc0000091)
#define STATUS_FLOAT_STACK_CHECK                    ((NTSTATUS)0xc0000092)
#define STATUS_FLOAT_UNDERFLOW                      ((NTSTATUS)0xc0000093)
#define STATUS_INTEGER_DIVIDE_BY_ZERO               ((NTSTATUS)0xc0000094)
#define STATUS_INTEGER_OVERFLOW                     ((NTSTATUS)0xc0000095)
#define STATUS_PRIVILEGED_INSTRUCTION               ((NTSTATUS)0xc0000096)
#define STATUS_TOO_MANY_PAGING_FILES                ((NTSTATUS)0xc0000097)
#define STATUS_FILE_INVALID                         ((NTSTATUS)0xc0000098)
#define STATUS_ALLOTTED_SPACE_EXCEEDED              ((NTSTATUS)0xc0000099)
#define STATUS_INSUFFICIENT_RESOURCES               ((NTSTATUS)0xc000009a)
#define STATUS_DFS_EXIT_PATH_FOUND                  ((NTSTATUS)0xc000009b)
#define STATUS_DEVICE_DATA_ERROR                    ((NTSTATUS)0xc000009c)
#define STATUS_DEVICE_NOT_CONNECTED                 ((NTSTATUS)0xc000009d)
#define STATUS_DEVICE_POWER_FAILURE                 ((NTSTATUS)0xc000009e)
#define STATUS_FREE_VM_NOT_AT_BASE                  ((NTSTATUS)0xc000009f)
#define STATUS_MEMORY_NOT_ALLOCATED                 ((NTSTATUS)0xc00000a0)
#define STATUS_WORKING_SET_QUOTA                    ((NTSTATUS)0xc00000a1)
#define STATUS_MEDIA_WRITE_PROTECTED                ((NTSTATUS)0xc00000a2)
#define STATUS_DEVICE_NOT_READY                     ((NTSTATUS)0xc00000a3)
#define STATUS_INVALID_GROUP_ATTRIBUTES             ((NTSTATUS)0xc00000a4)
#define STATUS_BAD_IMPERSONATION_LEVEL              ((NTSTATUS)0xc00000a5)
#define STATUS_CANT_OPEN_ANONYMOUS                  ((NTSTATUS)0xc00000a6)
#define STATUS_BAD_VALIDATION_CLASS                 ((NTSTATUS)0xc00000a7)
#define STATUS_BAD_TOKEN_TYPE                       ((NTSTATUS)0xc00000a8)
#define STATUS_BAD_MASTER_BOOT_RECORD               ((NTSTATUS)0xc00000a9)
#define STATUS_INSTRUCTION_MISALIGNMENT             ((NTSTATUS)0xc00000aa)
#define STATUS_INSTANCE_NOT_AVAILABLE               ((NTSTATUS)0xc00000ab)
#define STATUS_PIPE_NOT_AVAILABLE                   ((NTSTATUS)0xc00000ac)
#define STATUS_INVALID_PIPE_STATE                   ((NTSTATUS)0xc00000ad)
#define STATUS_PIPE_BUSY                            ((NTSTATUS)0xc00000ae)
#define STATUS_ILLEGAL_FUNCTION                     ((NTSTATUS)0xc00000af)
#define STATUS_PIPE_DISCONNECTED                    ((NTSTATUS)0xc00000b0)
#define STATUS_PIPE_CLOSING                         ((NTSTATUS)0xc00000b1)
#define STATUS_PIPE_CONNECTED                       ((NTSTATUS)0xc00000b2)
#define STATUS_PIPE_LISTENING                       ((NTSTATUS)0xc00000b3)
#define STATUS_INVALID_READ_MODE                    ((NTSTATUS)0xc00000b4)
#define STATUS_IO_TIMEOUT                           ((NTSTATUS)0xc00000b5)
#define STATUS_FILE_FORCED_CLOSED                   ((NTSTATUS)0xc00000b6)
#define STATUS_PROFILING_NOT_STARTED                ((NTSTATUS)0xc00000b7)
#define STATUS_PROFILING_NOT_STOPPED                ((NTSTATUS)0xc00000b8)
#define STATUS_COULD_NOT_INTERPRET                  ((NTSTATUS)0xc00000b9)
#define STATUS_FILE_IS_A_DIRECTORY                  ((NTSTATUS)0xc00000ba)
#define STATUS_NOT_SUPPORTED                        ((NTSTATUS)0xc00000bb)
#define STATUS_REMOTE_NOT_LISTENING                 ((NTSTATUS)0xc00000bc)
#define STATUS_DUPLICATE_NAME                       ((NTSTATUS)0xc00000bd)
#define STATUS_BAD_NETWORK_PATH                     ((NTSTATUS)0xc00000be)
#define STATUS_NETWORK_BUSY                         ((NTSTATUS)0xc00000bf)
#define STATUS_DEVICE_DOES_NOT_EXIST                ((NTSTATUS)0xc00000c0)
#define STATUS_TOO_MANY_COMMANDS                    ((NTSTATUS)0xc00000c1)
#define STATUS_ADAPTER_HARDWARE_ERROR               ((NTSTATUS)0xc00000c2)
#define STATUS_INVALID_NETWORK_RESPONSE             ((NTSTATUS)0xc00000c3)
#define STATUS_UNEXPECTED_NETWORK_ERROR             ((NTSTATUS)0xc00000c4)
#define STATUS_BAD_REMOTE_ADAPTER                   ((NTSTATUS)0xc00000c5)
#define STATUS_PRINT_QUEUE_FULL                     ((NTSTATUS)0xc00000c6)
#define STATUS_NO_SPOOL_SPACE                       ((NTSTATUS)0xc00000c7)
#define STATUS_PRINT_CANCELLED                      ((NTSTATUS)0xc00000c8)
#define STATUS_NETWORK_NAME_DELETED                 ((NTSTATUS)0xc00000c9)
#define STATUS_NETWORK_ACCESS_DENIED                ((NTSTATUS)0xc00000ca)
#define STATUS_BAD_DEVICE_TYPE                      ((NTSTATUS)0xc00000cb)
#define STATUS_BAD_NETWORK_NAME                     ((NTSTATUS)0xc00000cc)
#define STATUS_TOO_MANY_NAMES                       ((NTSTATUS)0xc00000cd)
#define STATUS_TOO_MANY_SESSIONS                    ((NTSTATUS)0xc00000ce)
#define STATUS_SHARING_PAUSED                       ((NTSTATUS)0xc00000cf)
#define STATUS_REQUEST_NOT_ACCEPTED                 ((NTSTATUS)0xc00000d0)
#define STATUS_REDIRECTOR_PAUSED                    ((NTSTATUS)0xc00000d1)
#define STATUS_NET_WRITE_FAULT                      ((NTSTATUS)0xc00000d2)
#define STATUS_PROFILING_AT_LIMIT                   ((NTSTATUS)0xc00000d3)
#define STATUS_NOT_SAME_DEVICE                      ((NTSTATUS)0xc00000d4)
#define STATUS_FILE_RENAMED                         ((NTSTATUS)0xc00000d5)
#define STATUS_VIRTUAL_CIRCUIT_CLOSED               ((NTSTATUS)0xc00000d6)
#define STATUS_NO_SECURITY_ON_OBJECT                ((NTSTATUS)0xc00000d7)
#define STATUS_CANT_WAIT                            ((NTSTATUS)0xc00000d8)
#define STATUS_PIPE_EMPTY                           ((NTSTATUS)0xc00000d9)
#define STATUS_CANT_ACCESS_DOMAIN_INFO              ((NTSTATUS)0xc00000da)
#define STATUS_CANT_TERMINATE_SELF                  ((NTSTATUS)0xc00000db)
#define STATUS_INVALID_SERVER_STATE                 ((NTSTATUS)0xc00000dc)
#define STATUS_INVALID_DOMAIN_STATE                 ((NTSTATUS)0xc00000dd)
#define STATUS_INVALID_DOMAIN_ROLE                  ((NTSTATUS)0xc00000de)
#define STATUS_NO_SUCH_DOMAIN                       ((NTSTATUS)0xc00000df)
#define STATUS_DOMAIN_EXISTS                        ((NTSTATUS)0xc00000e0)
#define STATUS_DOMAIN_LIMIT_EXCEEDED                ((NTSTATUS)0xc00000e1)
#define STATUS_OPLOCK_NOT_GRANTED                   ((NTSTATUS)0xc00000e2)
#define STATUS_INVALID_OPLOCK_PROTOCOL              ((NTSTATUS)0xc00000e3)
#define STATUS_INTERNAL_DB_CORRUPTION               ((NTSTATUS)0xc00000e4)
#define STATUS_INTERNAL_ERROR                       ((NTSTATUS)0xc00000e5)
#define STATUS_GENERIC_NOT_MAPPED                   ((NTSTATUS)0xc00000e6)
#define STATUS_BAD_DESCRIPTOR_FORMAT                ((NTSTATUS)0xc00000e7)
#define STATUS_INVALID_USER_BUFFER                  ((NTSTATUS)0xc00000e8)
#define STATUS_UNEXPECTED_IO_ERROR                  ((NTSTATUS)0xc00000e9)
#define STATUS_UNEXPECTED_MM_CREATE_ERR             ((NTSTATUS)0xc00000ea)
#define STATUS_UNEXPECTED_MM_MAP_ERROR              ((NTSTATUS)0xc00000eb)
#define STATUS_UNEXPECTED_MM_EXTEND_ERR             ((NTSTATUS)0xc00000ec)
#define STATUS_NOT_LOGON_PROCESS                    ((NTSTATUS)0xc00000ed)
#define STATUS_LOGON_SESSION_EXISTS                 ((NTSTATUS)0xc00000ee)
#define STATUS_INVALID_PARAMETER_1                  ((NTSTATUS)0xc00000ef)
#define STATUS_INVALID_PARAMETER_2                  ((NTSTATUS)0xc00000f0)
#define STATUS_INVALID_PARAMETER_3                  ((NTSTATUS)0xc00000f1)
#define STATUS_INVALID_PARAMETER_4                  ((NTSTATUS)0xc00000f2)
#define STATUS_INVALID_PARAMETER_5                  ((NTSTATUS)0xc00000f3)
#define STATUS_INVALID_PARAMETER_6                  ((NTSTATUS)0xc00000f4)
#define STATUS_INVALID_PARAMETER_7                  ((NTSTATUS)0xc00000f5)
#define STATUS_INVALID_PARAMETER_8                  ((NTSTATUS)0xc00000f6)
#define STATUS_INVALID_PARAMETER_9                  ((NTSTATUS)0xc00000f7)
#define STATUS_INVALID_PARAMETER_10                 ((NTSTATUS)0xc00000f8)
#define STATUS_INVALID_PARAMETER_11                 ((NTSTATUS)0xc00000f9)
#define STATUS_INVALID_PARAMETER_12                 ((NTSTATUS)0xc00000fa)
#define STATUS_REDIRECTOR_NOT_STARTED               ((NTSTATUS)0xc00000fb)
#define STATUS_REDIRECTOR_STARTED                   ((NTSTATUS)0xc00000fc)
#define STATUS_STACK_OVERFLOW                       ((NTSTATUS)0xc00000fd)
#define STATUS_NO_SUCH_PACKAGE                      ((NTSTATUS)0xc00000fe)
#define STATUS_BAD_FUNCTION_TABLE                   ((NTSTATUS)0xc00000ff)
#define STATUS_VARIABLE_NOT_FOUND                   ((NTSTATUS)0xc0000100)
#define STATUS_DIRECTORY_NOT_EMPTY                  ((NTSTATUS)0xc0000101)
#define STATUS_FILE_CORRUPT_ERROR                   ((NTSTATUS)0xc0000102)
#define STATUS_NOT_A_DIRECTORY                      ((NTSTATUS)0xc0000103)
#define STATUS_BAD_LOGON_SESSION_STATE              ((NTSTATUS)0xc0000104)
#define STATUS_LOGON_SESSION_COLLISION              ((NTSTATUS)0xc0000105)
#define STATUS_NAME_TOO_LONG                        ((NTSTATUS)0xc0000106)
#define STATUS_FILES_OPEN                           ((NTSTATUS)0xc0000107)
#define STATUS_CONNECTION_IN_USE                    ((NTSTATUS)0xc0000108)
#define STATUS_MESSAGE_NOT_FOUND                    ((NTSTATUS)0xc0000109)
#define STATUS_PROCESS_IS_TERMINATING               ((NTSTATUS)0xc000010a)
#define STATUS_INVALID_LOGON_TYPE                   ((NTSTATUS)0xc000010b)
#define STATUS_NO_GUID_TRANSLATION                  ((NTSTATUS)0xc000010c)
#define STATUS_CANNOT_IMPERSONATE                   ((NTSTATUS)0xc000010d)
#define STATUS_IMAGE_ALREADY_LOADED                 ((NTSTATUS)0xc000010e)
#define STATUS_ABIOS_NOT_PRESENT                    ((NTSTATUS)0xc000010f)
#define STATUS_ABIOS_LID_NOT_EXIST                  ((NTSTATUS)0xc0000110)
#define STATUS_ABIOS_LID_ALREADY_OWNED              ((NTSTATUS)0xc0000111)
#define STATUS_ABIOS_NOT_LID_OWNER                  ((NTSTATUS)0xc0000112)
#define STATUS_ABIOS_INVALID_COMMAND                ((NTSTATUS)0xc0000113)
#define STATUS_ABIOS_INVALID_LID                    ((NTSTATUS)0xc0000114)
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE         ((NTSTATUS)0xc0000115)
#define STATUS_ABIOS_INVALID_SELECTOR               ((NTSTATUS)0xc0000116)
#define STATUS_NO_LDT                               ((NTSTATUS)0xc0000117)
#define STATUS_INVALID_LDT_SIZE                     ((NTSTATUS)0xc0000118)
#define STATUS_INVALID_LDT_OFFSET                   ((NTSTATUS)0xc0000119)
#define STATUS_INVALID_LDT_DESCRIPTOR               ((NTSTATUS)0xc000011a)
#define STATUS_INVALID_IMAGE_NE_FORMAT              ((NTSTATUS)0xc000011b)
#define STATUS_RXACT_INVALID_STATE                  ((NTSTATUS)0xc000011c)
#define STATUS_RXACT_COMMIT_FAILURE                 ((NTSTATUS)0xc000011d)
#define STATUS_MAPPED_FILE_SIZE_ZERO                ((NTSTATUS)0xc000011e)
#define STATUS_TOO_MANY_OPENED_FILES                ((NTSTATUS)0xc000011f)
#define STATUS_CANCELLED                            ((NTSTATUS)0xc0000120)
#define STATUS_CANNOT_DELETE                        ((NTSTATUS)0xc0000121)
#define STATUS_INVALID_COMPUTER_NAME                ((NTSTATUS)0xc0000122)
#define STATUS_FILE_DELETED                         ((NTSTATUS)0xc0000123)
#define STATUS_SPECIAL_ACCOUNT                      ((NTSTATUS)0xc0000124)
#define STATUS_SPECIAL_GROUP                        ((NTSTATUS)0xc0000125)
#define STATUS_SPECIAL_USER                         ((NTSTATUS)0xc0000126)
#define STATUS_MEMBERS_PRIMARY_GROUP                ((NTSTATUS)0xc0000127)
#define STATUS_FILE_CLOSED                          ((NTSTATUS)0xc0000128)
#define STATUS_TOO_MANY_THREADS                     ((NTSTATUS)0xc0000129)
#define STATUS_THREAD_NOT_IN_PROCESS                ((NTSTATUS)0xc000012a)
#define STATUS_TOKEN_ALREADY_IN_USE                 ((NTSTATUS)0xc000012b)
#define STATUS_PAGEFILE_QUOTA_EXCEEDED              ((NTSTATUS)0xc000012c)
#define STATUS_COMMITMENT_LIMIT                     ((NTSTATUS)0xc000012d)
#define STATUS_INVALID_IMAGE_LE_FORMAT              ((NTSTATUS)0xc000012e)
#define STATUS_INVALID_IMAGE_NOT_MZ                 ((NTSTATUS)0xc000012f)
#define STATUS_INVALID_IMAGE_PROTECT                ((NTSTATUS)0xc0000130)
#define STATUS_INVALID_IMAGE_WIN_16                 ((NTSTATUS)0xc0000131)
#define STATUS_LOGON_SERVER_CONFLICT                ((NTSTATUS)0xc0000132)
#define STATUS_TIME_DIFFERENCE_AT_DC                ((NTSTATUS)0xc0000133)
#define STATUS_SYNCHRONIZATION_REQUIRED             ((NTSTATUS)0xc0000134)
#define STATUS_DLL_NOT_FOUND                        ((NTSTATUS)0xc0000135)
#define STATUS_OPEN_FAILED                          ((NTSTATUS)0xc0000136)
#define STATUS_IO_PRIVILEGE_FAILED                  ((NTSTATUS)0xc0000137)
#define STATUS_ORDINAL_NOT_FOUND                    ((NTSTATUS)0xc0000138)
#define STATUS_ENTRYPOINT_NOT_FOUND                 ((NTSTATUS)0xc0000139)
#define STATUS_CONTROL_C_EXIT                       ((NTSTATUS)0xc000013a)
#define STATUS_LOCAL_DISCONNECT                     ((NTSTATUS)0xc000013b)
#define STATUS_REMOTE_DISCONNECT                    ((NTSTATUS)0xc000013c)
#define STATUS_REMOTE_RESOURCES                     ((NTSTATUS)0xc000013d)
#define STATUS_LINK_FAILED                          ((NTSTATUS)0xc000013e)
#define STATUS_LINK_TIMEOUT                         ((NTSTATUS)0xc000013f)
#define STATUS_INVALID_CONNECTION                   ((NTSTATUS)0xc0000140)
#define STATUS_INVALID_ADDRESS                      ((NTSTATUS)0xc0000141)
#define STATUS_DLL_INIT_FAILED                      ((NTSTATUS)0xc0000142)
#define STATUS_MISSING_SYSTEMFILE                   ((NTSTATUS)0xc0000143)
#define STATUS_UNHANDLED_EXCEPTION                  ((NTSTATUS)0xc0000144)
#define STATUS_APP_INIT_FAILURE                     ((NTSTATUS)0xc0000145)
#define STATUS_PAGEFILE_CREATE_FAILED               ((NTSTATUS)0xc0000146)
#define STATUS_NO_PAGEFILE                          ((NTSTATUS)0xc0000147)
#define STATUS_INVALID_LEVEL                        ((NTSTATUS)0xc0000148)
#define STATUS_WRONG_PASSWORD_CORE                  ((NTSTATUS)0xc0000149)
#define STATUS_ILLEGAL_FLOAT_CONTEXT                ((NTSTATUS)0xc000014a)
#define STATUS_PIPE_BROKEN                          ((NTSTATUS)0xc000014b)
#define STATUS_REGISTRY_CORRUPT                     ((NTSTATUS)0xc000014c)
#define STATUS_REGISTRY_IO_FAILED                   ((NTSTATUS)0xc000014d)
#define STATUS_NO_EVENT_PAIR                        ((NTSTATUS)0xc000014e)
#define STATUS_UNRECOGNIZED_VOLUME                  ((NTSTATUS)0xc000014f)
#define STATUS_SERIAL_NO_DEVICE_INITED              ((NTSTATUS)0xc0000150)
#define STATUS_NO_SUCH_ALIAS                        ((NTSTATUS)0xc0000151)
#define STATUS_MEMBER_NOT_IN_ALIAS                  ((NTSTATUS)0xc0000152)
#define STATUS_MEMBER_IN_ALIAS                      ((NTSTATUS)0xc0000153)
#define STATUS_ALIAS_EXISTS                         ((NTSTATUS)0xc0000154)
#define STATUS_LOGON_NOT_GRANTED                    ((NTSTATUS)0xc0000155)
#define STATUS_TOO_MANY_SECRETS                     ((NTSTATUS)0xc0000156)
#define STATUS_SECRET_TOO_LONG                      ((NTSTATUS)0xc0000157)
#define STATUS_INTERNAL_DB_ERROR                    ((NTSTATUS)0xc0000158)
#define STATUS_FULLSCREEN_MODE                      ((NTSTATUS)0xc0000159)
#define STATUS_TOO_MANY_CONTEXT_IDS                 ((NTSTATUS)0xc000015a)
#define STATUS_LOGON_TYPE_NOT_GRANTED               ((NTSTATUS)0xc000015b)
#define STATUS_NOT_REGISTRY_FILE                    ((NTSTATUS)0xc000015c)
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED         ((NTSTATUS)0xc000015d)
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR            ((NTSTATUS)0xc000015e)
#define STATUS_FT_MISSING_MEMBER                    ((NTSTATUS)0xc000015f)
#define STATUS_ILL_FORMED_SERVICE_ENTRY             ((NTSTATUS)0xc0000160)
#define STATUS_ILLEGAL_CHARACTER                    ((NTSTATUS)0xc0000161)
#define STATUS_UNMAPPABLE_CHARACTER                 ((NTSTATUS)0xc0000162)
#define STATUS_UNDEFINED_CHARACTER                  ((NTSTATUS)0xc0000163)
#define STATUS_FLOPPY_VOLUME                        ((NTSTATUS)0xc0000164)
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND             ((NTSTATUS)0xc0000165)
#define STATUS_FLOPPY_WRONG_CYLINDER                ((NTSTATUS)0xc0000166)
#define STATUS_FLOPPY_UNKNOWN_ERROR                 ((NTSTATUS)0xc0000167)
#define STATUS_FLOPPY_BAD_REGISTERS                 ((NTSTATUS)0xc0000168)
#define STATUS_DISK_RECALIBRATE_FAILED              ((NTSTATUS)0xc0000169)
#define STATUS_DISK_OPERATION_FAILED                ((NTSTATUS)0xc000016a)
#define STATUS_DISK_RESET_FAILED                    ((NTSTATUS)0xc000016b)
#define STATUS_SHARED_IRQ_BUSY                      ((NTSTATUS)0xc000016c)
#define STATUS_FT_ORPHANING                         ((NTSTATUS)0xc000016d)
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT     ((NTSTATUS)0xc000016e)

#define STATUS_PARTITION_FAILURE                    ((NTSTATUS)0xc0000172)
#define STATUS_INVALID_BLOCK_LENGTH                 ((NTSTATUS)0xc0000173)
#define STATUS_DEVICE_NOT_PARTITIONED               ((NTSTATUS)0xc0000174)
#define STATUS_UNABLE_TO_LOCK_MEDIA                 ((NTSTATUS)0xc0000175)
#define STATUS_UNABLE_TO_UNLOAD_MEDIA               ((NTSTATUS)0xc0000176)
#define STATUS_EOM_OVERFLOW                         ((NTSTATUS)0xc0000177)
#define STATUS_NO_MEDIA                             ((NTSTATUS)0xc0000178)

#define STATUS_NO_SUCH_MEMBER                       ((NTSTATUS)0xc000017a)
#define STATUS_INVALID_MEMBER                       ((NTSTATUS)0xc000017b)
#define STATUS_KEY_DELETED                          ((NTSTATUS)0xc000017c)
#define STATUS_NO_LOG_SPACE                         ((NTSTATUS)0xc000017d)
#define STATUS_TOO_MANY_SIDS                        ((NTSTATUS)0xc000017e)
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED         ((NTSTATUS)0xc000017f)
#define STATUS_KEY_HAS_CHILDREN                     ((NTSTATUS)0xc0000180)
#define STATUS_CHILD_MUST_BE_VOLATILE               ((NTSTATUS)0xc0000181)
#define STATUS_DEVICE_CONFIGURATION_ERROR           ((NTSTATUS)0xc0000182)
#define STATUS_DRIVER_INTERNAL_ERROR                ((NTSTATUS)0xc0000183)
#define STATUS_INVALID_DEVICE_STATE                 ((NTSTATUS)0xc0000184)
#define STATUS_IO_DEVICE_ERROR                      ((NTSTATUS)0xc0000185)
#define STATUS_DEVICE_PROTOCOL_ERROR                ((NTSTATUS)0xc0000186)
#define STATUS_BACKUP_CONTROLLER                    ((NTSTATUS)0xc0000187)
#define STATUS_LOG_FILE_FULL                        ((NTSTATUS)0xc0000188)
#define STATUS_TOO_LATE                             ((NTSTATUS)0xc0000189)
#define STATUS_NO_TRUST_LSA_SECRET                  ((NTSTATUS)0xc000018a)
#define STATUS_NO_TRUST_SAM_ACCOUNT                 ((NTSTATUS)0xc000018b)
#define STATUS_TRUSTED_DOMAIN_FAILURE               ((NTSTATUS)0xc000018c)
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE         ((NTSTATUS)0xc000018d)
#define STATUS_EVENTLOG_FILE_CORRUPT                ((NTSTATUS)0xc000018e)
#define STATUS_EVENTLOG_CANT_START                  ((NTSTATUS)0xc000018f)
#define STATUS_TRUST_FAILURE                        ((NTSTATUS)0xc0000190)
#define STATUS_MUTANT_LIMIT_EXCEEDED                ((NTSTATUS)0xc0000191)
#define STATUS_NETLOGON_NOT_STARTED                 ((NTSTATUS)0xc0000192)
#define STATUS_ACCOUNT_EXPIRED                      ((NTSTATUS)0xc0000193)
#define STATUS_POSSIBLE_DEADLOCK                    ((NTSTATUS)0xc0000194)
#define STATUS_NETWORK_CREDENTIAL_CONFLICT          ((NTSTATUS)0xc0000195)
#define STATUS_REMOTE_SESSION_LIMIT                 ((NTSTATUS)0xc0000196)
#define STATUS_EVENTLOG_FILE_CHANGED                ((NTSTATUS)0xc0000197)
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT    ((NTSTATUS)0xc0000198)
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT    ((NTSTATUS)0xc0000199)
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT         ((NTSTATUS)0xc000019a)
#define STATUS_DOMAIN_TRUST_INCONSISTENT            ((NTSTATUS)0xc000019b)
#define STATUS_FS_DRIVER_REQUIRED                   ((NTSTATUS)0xc000019c)

#define STATUS_NO_USER_SESSION_KEY                  ((NTSTATUS)0xc0000202)
#define STATUS_USER_SESSION_DELETED                 ((NTSTATUS)0xc0000203)
#define STATUS_RESOURCE_LANG_NOT_FOUND              ((NTSTATUS)0xc0000204)
#define STATUS_INSUFF_SERVER_RESOURCES              ((NTSTATUS)0xc0000205)
#define STATUS_INVALID_BUFFER_SIZE                  ((NTSTATUS)0xc0000206)
#define STATUS_INVALID_ADDRESS_COMPONENT            ((NTSTATUS)0xc0000207)
#define STATUS_INVALID_ADDRESS_WILDCARD             ((NTSTATUS)0xc0000208)
#define STATUS_TOO_MANY_ADDRESSES                   ((NTSTATUS)0xc0000209)
#define STATUS_ADDRESS_ALREADY_EXISTS               ((NTSTATUS)0xc000020a)
#define STATUS_ADDRESS_CLOSED                       ((NTSTATUS)0xc000020b)
#define STATUS_CONNECTION_DISCONNECTED              ((NTSTATUS)0xc000020c)
#define STATUS_CONNECTION_RESET                     ((NTSTATUS)0xc000020d)
#define STATUS_TOO_MANY_NODES                       ((NTSTATUS)0xc000020e)
#define STATUS_TRANSACTION_ABORTED                  ((NTSTATUS)0xc000020f)
#define STATUS_TRANSACTION_TIMED_OUT                ((NTSTATUS)0xc0000210)
#define STATUS_TRANSACTION_NO_RELEASE               ((NTSTATUS)0xc0000211)
#define STATUS_TRANSACTION_NO_MATCH                 ((NTSTATUS)0xc0000212)
#define STATUS_TRANSACTION_RESPONDED                ((NTSTATUS)0xc0000213)
#define STATUS_TRANSACTION_INVALID_ID               ((NTSTATUS)0xc0000214)
#define STATUS_TRANSACTION_INVALID_TYPE             ((NTSTATUS)0xc0000215)
#define STATUS_NOT_SERVER_SESSION                   ((NTSTATUS)0xc0000216)
#define STATUS_NOT_CLIENT_SESSION                   ((NTSTATUS)0xc0000217)
#define STATUS_CANNOT_LOAD_REGISTRY_FILE            ((NTSTATUS)0xc0000218)
#define STATUS_DEBUG_ATTACH_FAILED                  ((NTSTATUS)0xc0000219)
#define STATUS_SYSTEM_PROCESS_TERMINATED            ((NTSTATUS)0xc000021a)
#define STATUS_DATA_NOT_ACCEPTED                    ((NTSTATUS)0xc000021b)
#define STATUS_NO_BROWSER_SERVERS_FOUND             ((NTSTATUS)0xc000021c)
#define STATUS_VDM_HARD_ERROR                       ((NTSTATUS)0xc000021d)
#define STATUS_DRIVER_CANCEL_TIMEOUT                ((NTSTATUS)0xc000021e)
#define STATUS_REPLY_MESSAGE_MISMATCH               ((NTSTATUS)0xc000021f)
#define STATUS_MAPPED_ALIGNMENT                     ((NTSTATUS)0xc0000220)
#define STATUS_IMAGE_CHECKSUM_MISMATCH              ((NTSTATUS)0xc0000221)
#define STATUS_LOST_WRITEBEHIND_DATA                ((NTSTATUS)0xc0000222)
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID     ((NTSTATUS)0xc0000223)
#define STATUS_PASSWORD_MUST_CHANGE                 ((NTSTATUS)0xc0000224)
#define STATUS_NOT_FOUND                            ((NTSTATUS)0xc0000225)
#define STATUS_NOT_TINY_STREAM                      ((NTSTATUS)0xc0000226)
#define STATUS_RECOVERY_FAILURE                     ((NTSTATUS)0xc0000227)
#define STATUS_STACK_OVERFLOW_READ                  ((NTSTATUS)0xc0000228)
#define STATUS_FAIL_CHECK                           ((NTSTATUS)0xc0000229)
#define STATUS_DUPLICATE_OBJECTID                   ((NTSTATUS)0xc000022a)
#define STATUS_OBJECTID_EXISTS                      ((NTSTATUS)0xc000022b)
#define STATUS_CONVERT_TO_LARGE                     ((NTSTATUS)0xc000022c)
#define STATUS_RETRY                                ((NTSTATUS)0xc000022d)
#define STATUS_FOUND_OUT_OF_SCOPE                   ((NTSTATUS)0xc000022e)
#define STATUS_ALLOCATE_BUCKET                      ((NTSTATUS)0xc000022f)
#define STATUS_PROPSET_NOT_FOUND                    ((NTSTATUS)0xc0000230)
#define STATUS_MARSHALL_OVERFLOW                    ((NTSTATUS)0xc0000231)
#define STATUS_INVALID_VARIANT                      ((NTSTATUS)0xc0000232)
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND          ((NTSTATUS)0xc0000233)
#define STATUS_ACCOUNT_LOCKED_OUT                   ((NTSTATUS)0xc0000234)
#define STATUS_HANDLE_NOT_CLOSABLE                  ((NTSTATUS)0xc0000235)
#define STATUS_CONNECTION_REFUSED                   ((NTSTATUS)0xc0000236)
#define STATUS_GRACEFUL_DISCONNECT                  ((NTSTATUS)0xc0000237)
#define STATUS_ADDRESS_ALREADY_ASSOCIATED           ((NTSTATUS)0xc0000238)
#define STATUS_ADDRESS_NOT_ASSOCIATED               ((NTSTATUS)0xc0000239)
#define STATUS_CONNECTION_INVALID                   ((NTSTATUS)0xc000023a)
#define STATUS_CONNECTION_ACTIVE                    ((NTSTATUS)0xc000023b)
#define STATUS_NETWORK_UNREACHABLE                  ((NTSTATUS)0xc000023c)
#define STATUS_HOST_UNREACHABLE                     ((NTSTATUS)0xc000023d)
#define STATUS_PROTOCOL_UNREACHABLE                 ((NTSTATUS)0xc000023e)
#define STATUS_PORT_UNREACHABLE                     ((NTSTATUS)0xc000023f)
#define STATUS_REQUEST_ABORTED                      ((NTSTATUS)0xc0000240)
#define STATUS_CONNECTION_ABORTED                   ((NTSTATUS)0xc0000241)
#define STATUS_BAD_COMPRESSION_BUFFER               ((NTSTATUS)0xc0000242)
#define STATUS_USER_MAPPED_FILE                     ((NTSTATUS)0xc0000243)
#define STATUS_AUDIT_FAILED                         ((NTSTATUS)0xc0000244)
#define STATUS_TIMER_RESOLUTION_NOT_SET             ((NTSTATUS)0xc0000245)
#define STATUS_CONNECTION_COUNT_LIMIT               ((NTSTATUS)0xc0000246)
#define STATUS_LOGIN_TIME_RESTRICTION               ((NTSTATUS)0xc0000247)
#define STATUS_LOGIN_WKSTA_RESTRICTION              ((NTSTATUS)0xc0000248)
#define STATUS_IMAGE_MP_UP_MISMATCH                 ((NTSTATUS)0xc0000249)

#define STATUS_INSUFFICIENT_LOGON_INFO              ((NTSTATUS)0xc0000250)
#define STATUS_BAD_DLL_ENTRYPOINT                   ((NTSTATUS)0xc0000251)
#define STATUS_BAD_SERVICE_ENTRYPOINT               ((NTSTATUS)0xc0000252)
#define STATUS_LPC_REPLY_LOST                       ((NTSTATUS)0xc0000253)
#define STATUS_IP_ADDRESS_CONFLICT1                 ((NTSTATUS)0xc0000254)
#define STATUS_IP_ADDRESS_CONFLICT2                 ((NTSTATUS)0xc0000255)
#define STATUS_REGISTRY_QUOTA_LIMIT                 ((NTSTATUS)0xc0000256)
#define STATUS_PATH_NOT_COVERED                     ((NTSTATUS)0xc0000257)
#define STATUS_NO_CALLBACK_ACTIVE                   ((NTSTATUS)0xc0000258)
#define STATUS_LICENSE_QUOTA_EXCEEDED               ((NTSTATUS)0xc0000259)
#define STATUS_PWD_TOO_SHORT                        ((NTSTATUS)0xc000025a)
#define STATUS_PWD_TOO_RECENT                       ((NTSTATUS)0xc000025b)
#define STATUS_PWD_HISTORY_CONFLICT                 ((NTSTATUS)0xc000025c)
#define STATUS_PLUGPLAY_NO_DEVICE                   ((NTSTATUS)0xc000025e)
#define STATUS_UNSUPPORTED_COMPRESSION              ((NTSTATUS)0xc000025f)
#define STATUS_INVALID_HW_PROFILE                   ((NTSTATUS)0xc0000260)
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH         ((NTSTATUS)0xc0000261)
#define STATUS_DRIVER_ORDINAL_NOT_FOUND             ((NTSTATUS)0xc0000262)
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND          ((NTSTATUS)0xc0000263)
#define STATUS_RESOURCE_NOT_OWNED                   ((NTSTATUS)0xc0000264)
#define STATUS_TOO_MANY_LINKS                       ((NTSTATUS)0xc0000265)
#define STATUS_QUOTA_LIST_INCONSISTENT              ((NTSTATUS)0xc0000266)
#define STATUS_FILE_IS_OFFLINE                      ((NTSTATUS)0xc0000267)
#define STATUS_EVALUATION_EXPIRATION                ((NTSTATUS)0xc0000268)
#define STATUS_ILLEGAL_DLL_RELOCATION               ((NTSTATUS)0xc0000269)
#define STATUS_LICENSE_VIOLATION                    ((NTSTATUS)0xc000026a)
#define STATUS_DLL_INIT_FAILED_LOGOFF               ((NTSTATUS)0xc000026b)
#define STATUS_DRIVER_UNABLE_TO_LOAD                ((NTSTATUS)0xc000026c)
#define STATUS_DFS_UNAVAILABLE                      ((NTSTATUS)0xc000026d)
#define STATUS_VOLUME_DISMOUNTED                    ((NTSTATUS)0xc000026e)
#define STATUS_WX86_INTERNAL_ERROR                  ((NTSTATUS)0xc000026f)
#define STATUS_WX86_FLOAT_STACK_CHECK               ((NTSTATUS)0xc0000270)
#define STATUS_VALIDATE_CONTINUE                    ((NTSTATUS)0xc0000271)
#define STATUS_NO_MATCH                             ((NTSTATUS)0xc0000272)
#define STATUS_NO_MORE_MATCHES                      ((NTSTATUS)0xc0000273)
#define STATUS_INVALID_VLM_OPERATION                ((NTSTATUS)0xc0000274)
#define STATUS_NOT_A_REPARSE_POINT                  ((NTSTATUS)0xc0000275)
#define STATUS_IO_REPARSE_TAG_INVALID               ((NTSTATUS)0xc0000276)
#define STATUS_IO_REPARSE_TAG_MISMATCH              ((NTSTATUS)0xc0000277)
#define STATUS_IO_REPARSE_DATA_INVALID              ((NTSTATUS)0xc0000278)
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED           ((NTSTATUS)0xc0000279)


#define STATUS_SAM_INIT_FAILURE                     ((NTSTATUS)0xC00002CB)


#define RPC_NT_INVALID_STRING_BINDING               ((NTSTATUS)0xC0020001)
#define RPC_NT_WRONG_KIND_OF_BINDING                ((NTSTATUS)0xC0020002)
#define RPC_NT_INVALID_BINDING                      ((NTSTATUS)0xC0020003)
#define RPC_NT_PROTSEQ_NOT_SUPPORTED                ((NTSTATUS)0xC0020004)
#define RPC_NT_INVALID_RPC_PROTSEQ                  ((NTSTATUS)0xC0020005)
#define RPC_NT_INVALID_STRING_UUID                  ((NTSTATUS)0xC0020006)
#define RPC_NT_INVALID_ENDPOINT_FORMAT              ((NTSTATUS)0xC0020007)
#define RPC_NT_INVALID_NET_ADDR                     ((NTSTATUS)0xC0020008)
#define RPC_NT_NO_ENDPOINT_FOUND                    ((NTSTATUS)0xC0020009)
#define RPC_NT_INVALID_TIMEOUT                      ((NTSTATUS)0xC002000A)
#define RPC_NT_OBJECT_NOT_FOUND                     ((NTSTATUS)0xC002000B)
#define RPC_NT_ALREADY_REGISTERED                   ((NTSTATUS)0xC002000C)
#define RPC_NT_TYPE_ALREADY_REGISTERED              ((NTSTATUS)0xC002000D)
#define RPC_NT_ALREADY_LISTENING                    ((NTSTATUS)0xC002000E)
#define RPC_NT_NO_PROTSEQS_REGISTERED               ((NTSTATUS)0xC002000F)
#define RPC_NT_NOT_LISTENING                        ((NTSTATUS)0xC0020010)
#define RPC_NT_UNKNOWN_MGR_TYPE                     ((NTSTATUS)0xC0020011)
#define RPC_NT_UNKNOWN_IF                           ((NTSTATUS)0xC0020012)
#define RPC_NT_NO_BINDINGS                          ((NTSTATUS)0xC0020013)
#define RPC_NT_NO_PROTSEQS                          ((NTSTATUS)0xC0020014)
#define RPC_NT_CANT_CREATE_ENDPOINT                 ((NTSTATUS)0xC0020015)
#define RPC_NT_OUT_OF_RESOURCES                     ((NTSTATUS)0xC0020016)
#define RPC_NT_SERVER_UNAVAILABLE                   ((NTSTATUS)0xC0020017)
#define RPC_NT_SERVER_TOO_BUSY                      ((NTSTATUS)0xC0020018)
#define RPC_NT_INVALID_NETWORK_OPTIONS              ((NTSTATUS)0xC0020019)
#define RPC_NT_NO_CALL_ACTIVE                       ((NTSTATUS)0xC002001A)
#define RPC_NT_CALL_FAILED                          ((NTSTATUS)0xC002001B)
#define RPC_NT_CALL_FAILED_DNE                      ((NTSTATUS)0xC002001C)
#define RPC_NT_PROTOCOL_ERROR                       ((NTSTATUS)0xC002001D)


#define RPC_NT_SS_IN_NULL_CONTEXT                   ((NTSTATUS)0xC0030004)

#else /* !__ASM__ */

#define STATUS_INVALID_SYSTEM_SERVICE               0xc000001c

#endif /* !__ASM__ */

#endif /* __INCLUDE_DDK_STATUS_H */






