/* $Id$
 *
 * COPYRIGHT:    See COPYING in the top level directory
 * PROJECT:      ReactOS kernel
 * FILE:         include/ntos/cdrom.h
 * PURPOSE:      CD-ROM related definitions used by all the parts of the system
 * PROGRAMMER:   Eric Kohl <ekohl@rz-online.de>
 * UPDATE HISTORY:
 *               10/04/2002: Created
 */

#ifndef __INCLUDE_NTOS_CDROM_H
#define __INCLUDE_NTOS_CDROM_H


#define IOCTL_CDROM_BASE                FILE_DEVICE_CD_ROM

#define IOCTL_CDROM_READ_TOC            CTL_CODE(IOCTL_CDROM_BASE, 0x0000, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_GET_LAST_SESSION    CTL_CODE(IOCTL_CDROM_BASE, 0x000E, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_GET_DRIVE_GEOMETRY  CTL_CODE(IOCTL_CDROM_BASE, 0x0013, METHOD_BUFFERED, FILE_READ_ACCESS)

#define IOCTL_CDROM_CHECK_VERIFY        CTL_CODE(IOCTL_CDROM_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_MEDIA_REMOVAL	CTL_CODE(IOCTL_CDROM_BASE, 0x0201, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_EJECT_MEDIA		CTL_CODE(IOCTL_CDROM_BASE, 0x0202, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_LOAD_MEDIA		CTL_CODE(IOCTL_CDROM_BASE, 0x0203, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_RESERVE		CTL_CODE(IOCTL_CDROM_BASE, 0x0204, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_RELEASE		CTL_CODE(IOCTL_CDROM_BASE, 0x0205, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_CDROM_FIND_NEW_DEVICES	CTL_CODE(IOCTL_CDROM_BASE, 0x0206, METHOD_BUFFERED, FILE_READ_ACCESS)


#define MAXIMUM_NUMBER_TRACKS		100
#define MAXIMUM_CDROM_SIZE		804

#define TOC_DATA_TRACK	0x04	/* TRACK_DATA.Control */
#define TOC_LAST_TRACK	0xAA	/* TRACK_DATA.TrackNumber */

typedef struct _TRACK_DATA
{
  UCHAR  Reserved;
  UCHAR  Control : 4;	/* bitfield; 0 || TOC_DATA_TRACK */
  UCHAR  Adr : 4;	/* Q-subchannel info */
  UCHAR  TrackNumber;	/* CDROM_TOC.FirstTrack or TOC_LAST_TRACK behind last track CDROM_TOC.TrackData[CDROM_TOC.LastTrack] */
  UCHAR  Reserved1;
  UCHAR  Address[4];	/* big-endian LBA address for TOC_DATA_TRACK; MSF (sometimes BCD-MSF) for audio */
} TRACK_DATA, *PTRACK_DATA;

typedef struct _CDROM_TOC
{
  /* >='sizeof(CDROM_TOC with (LastTrack-FirstTrack+1)+1{TOC_LAST_TRACK track} tracks)-2'
   * <='sizeof(CDROM_TOC)-2';
   * It does not count 'Length' field itself (==minus 2 bytes).
   * Little-endian format.
   */
  UCHAR  Length[2];
  UCHAR  FirstTrack;	/* based anywhere */
  UCHAR  LastTrack;	/* 'LastTrack-FirstTrack+1' is the real-tracks count; TOC_LAST_TRACK is one track behind */
  TRACK_DATA  TrackData[MAXIMUM_NUMBER_TRACKS];
} CDROM_TOC, *PCDROM_TOC;

#define CDROM_TOC_SIZE sizeof(CDROM_TOC)

#endif /* __INCLUDE_NTOS_CDROM_H */

/* EOF */
