
#ifndef __WIN32K_CURSORICON_H
#define __WIN32K_CURSORICON_H

#include <win32k/dc.h>
#include <win32k/gdiobj.h>

/* Structures for reading icon/cursor files and resources */
// Structures for reading icon files and resources 
typedef struct _ICONIMAGE
{
   BITMAPINFOHEADER   icHeader;      // DIB header
   RGBQUAD         icColors[1];   // Color table
   BYTE            icXOR[1];      // DIB bits for XOR mask
   BYTE            icAND[1];      // DIB bits for AND mask
} PACKED ICONIMAGE, *LPICONIMAGE;

typedef struct _CURSORIMAGE
{
   BITMAPINFOHEADER   icHeader;      // DIB header
   RGBQUAD         icColors[1];   // Color table
   BYTE            icXOR[1];      // DIB bits for XOR mask
   BYTE            icAND[1];      // DIB bits for AND mask
} PACKED CURSORIMAGE, *LPCURSORIMAGE;

typedef struct
{
    BYTE   bWidth;
    BYTE   bHeight;
    BYTE   bColorCount;
    BYTE   bReserved;
} PACKED ICONRESDIR;

typedef struct
{
    WORD   wWidth;
    WORD   wHeight;
} PACKED CURSORRESDIR;

typedef struct
{
    WORD   wPlanes;				// Number of Color Planes in the XOR image
    WORD   wBitCount;			// Bits per pixel in the XOR image
} PACKED ICONDIR;

typedef struct
{
    WORD   wXHotspot;				// Number of Color Planes in the XOR image
    WORD   wYHotspot;			// Bits per pixel in the XOR image
} PACKED CURSORDIR;

typedef struct
{
    BYTE   bWidth;				// Width, in pixels, of the icon image
    BYTE   bHeight;				// Height, in pixels, of the icon image
    BYTE   bColorCount;			// Number of colors in image (0 if >=8bpp)
    BYTE   bReserved;			// Reserved ( must be 0)
	union
    { ICONDIR icon;
      CURSORDIR  cursor;
    } Info;
    DWORD  dwBytesInRes;		// How many bytes in this resource?
    DWORD  dwImageOffset;		// Where in the file is this image?
} PACKED CURSORICONDIRENTRY;

typedef struct
{
    WORD				idReserved;		// Reserved (must be 0)
    WORD				idType;			// Resource Type (1 for icons, 0 for cursors)
    WORD				idCount;		// How many images?
    CURSORICONDIRENTRY  idEntries[1] __attribute__((packed));   // An entry for idCount number of images
} PACKED CURSORICONDIR;

typedef struct
{  
	union
    { ICONRESDIR icon;
      CURSORRESDIR  cursor;
    } ResInfo;
	WORD   wPlanes;              // Color Planes
	WORD   wBitCount;            // Bits per pixel
	DWORD  dwBytesInRes;         // how many bytes in this resource?
	WORD   nID;                  // the ID
} PACKED GRPCURSORICONDIRENTRY;

typedef struct 
{
   WORD            idReserved;   // Reserved (must be 0)
   WORD            idType;       // Resource type (1 for icons)
   WORD            idCount;      // How many images?
   GRPCURSORICONDIRENTRY   idEntries[1] PACKED; // The entries for each image
} PACKED GRPCURSORICONDIR;

/* GDI logical Icon/Cursor object */
typedef struct _ICONCURSOROBJ
{
	BOOL		fIcon;
	DWORD		xHotspot;
	DWORD		yHotspot;
	BITMAP		ANDBitmap;
	BITMAP		XORBitmap;
} ICONCURSOROBJ, *PICONCURSOROBJ;

/*  Internal interfaces  */
#define  ICONCURSOROBJ_AllocIconCursor()  \
  ((HICON) GDIOBJ_AllocObj (sizeof (ICONCURSOROBJ), GDI_OBJECT_TYPE_ICONCURSOR, (GDICLEANUPPROC) IconCursor_InternalDelete))

#define  ICONCURSOROBJ_LockIconCursor(hICObj)  \
  ((PICONCURSOROBJ) GDIOBJ_LockObj ((HGDIOBJ) hICObj, GDI_OBJECT_TYPE_ICONCURSOR))
  
#define  ICONCURSOROBJ_UnlockIconCursor(hICObj) GDIOBJ_UnlockObj ((HGDIOBJ) hICObj, GDI_OBJECT_TYPE_ICONCURSOR)


BOOL FASTCALL IconCursor_InternalDelete( PICONCURSOROBJ pIconCursor );

/*  User Entry Points  */
HICON 
STDCALL 
NtGdiCreateIcon (
    BOOL fIcon,
	INT  Width,
	INT  Height,
	UINT  Planes,
	UINT  BitsPerPel,
	DWORD xHotspot,
	DWORD yHotspot,
	const VOID *ANDBits,
	const VOID *XORBits
	);



#endif
