/* $Id$
 *
 * COPYRIGHT:       See COPYING in the top level directory
 * PROJECT:         ReactOS kernel
 * FILE:            ntoskrnl/ke/critical.c
 * PURPOSE:         Implement critical regions
 * PROGRAMMER:      David Welch (welch@mcmail.com)
 * UPDATE HISTORY:
 *                  Created 22/05/98
 */

/* INCLUDES *****************************************************************/

#include <ddk/ntddk.h>
#include <internal/ps.h>

#define NDEBUG
#include <internal/debug.h>

/* FUNCTIONS *****************************************************************/

/*
 * @implemented
 */
VOID STDCALL KeEnterCriticalRegion (VOID)
{
   DPRINT("KeEnterCriticalRegion()\n");
   if (KeGetCurrentThread()->KernelApcDisable<0)
      KeBugCheck(0);
   KeGetCurrentThread()->KernelApcDisable += 1;
}

/*
 * @implemented
 */
VOID STDCALL KeLeaveCriticalRegion (VOID)
{
   DPRINT("KeLeaveCriticalRegion()\n");
   if (KeGetCurrentThread()->KernelApcDisable<=0)
      KeBugCheck(0);
   KeGetCurrentThread()->KernelApcDisable -= 1;
}

/* EOF */
