/* $Id: cmd_cd.c,v 1.9 2003/12/13 21:20:05 short Exp $
 * client cmdline interface command "cd" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <string.h>
#include <captive/client-directory.h>
#include <stdio.h>
#include <captive/client.h>

#include "cmd_cd.h"	/* self */
#include "main.h"
#include "utf8.h"


/* Config: */
#define STATICS_NUM (5)


const gchar *cmdline_cwd;


GQuark cmdline_cmd_cd_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-cd");

	return r;
}


const struct poptOption cmd_cd_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


/* Returns: statically allocated absolute pathname string */
G_CONST_RETURN gchar *cmdline_path_from_cwd(const gchar *relative)
{
static gchar *statics[STATICS_NUM];
static int staticsi=0;
gchar *r,*s;

	/* 'relative' may be NULL for the '.' meaning */

	if (!cmdline_cwd || (relative && *relative==G_DIR_SEPARATOR)) {	/* bootstrap or absolute */
		g_assert(g_path_is_absolute(relative));
		s=g_strdup(relative);
		}
	else if (!relative)
		s=g_strdup(cmdline_cwd);
	else
		s=g_build_filename(cmdline_cwd,relative,NULL);
	g_assert(g_path_is_absolute(s));

	r=captive_path_normalize(s);
	g_free(s);

	g_free(statics[staticsi]);
	statics[staticsi++]=r;
	staticsi%=G_N_ELEMENTS(statics);

	return r;
}


void cmd_cd_internal(const gchar *targetdir,GError **errp)
{
CaptiveDirectoryObject *captive_directory_object;

	g_return_if_fail(targetdir!=NULL);
	g_return_if_fail(!errp || !*errp);

	if (!errvfsresult_to_gerr(errp,captive_directory_new_open(
			&captive_directory_object,	/* captive_directory_object_return */
			cmdline_captive_vfs_object,	/* captive_vfs_object */
			targetdir))) {	/* pathname */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_CD_ERROR,CMDLINE_CMD_CD_ERROR_CANNOT_OPEN_DIRECTORY,
				_("Cannot open directory: %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(targetdir));
		return;
		}

	g_object_unref(captive_directory_object);

	g_free((/*de-const*/ gchar *)cmdline_cwd);
	cmdline_cwd=g_strdup(targetdir);
	g_assert(g_path_is_absolute(cmdline_cwd));
}


void cmd_cd(const char **cmd_argv,GError **errp)
{
	g_return_if_fail(!errp || !*errp);

	if (cmd_argv[0])
		cmd_cd_internal(cmdline_path_from_cwd(cmd_argv[0]),errp);

	printf("Guest-OS CWD: %s\n",cmdline_cwd);
}
