/* $Id: cmd_cd.h,v 1.3 2003/09/13 18:11:29 short Exp $
 * Include file for client cmdline interface command "cd" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_CMDLINE_CMD_CD_H
#define _CAPTIVE_CLIENT_CMDLINE_CMD_CD_H 1


#include <glib/gerror.h>
#include <popt.h>


#define CMDLINE_CMD_CD_ERROR (cmdline_cmd_cd_error_quark())
GQuark cmdline_cmd_cd_error_quark(void);

typedef enum {
	CMDLINE_CMD_CD_ERROR_CANNOT_OPEN_DIRECTORY
	} CmdlineCmdCdError;


extern const struct poptOption cmd_cd_table[];

void cmd_cd_internal(const gchar *targetdir,GError **errp);
void cmd_cd(const char **cmd_argv,GError **errp);

G_CONST_RETURN gchar *cmdline_path_from_cwd(const gchar *relative);

extern const gchar *cmdline_cwd;


#endif /* _CAPTIVE_CLIENT_CMDLINE_CMD_CD_H */
