/* $Id: cmd_close.c,v 1.1 2003/11/10 08:54:30 short Exp $
 * client cmdline interface command "close" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <captive/client-file.h>

#include "cmd_close.h"	/* self */
#include "main.h"
#include "handle.h"


GQuark cmdline_cmd_close_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-close");

	return r;
}


const struct poptOption cmd_close_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_close(const char **cmd_argv,GError **errp)
{
const gchar *handle_name;

	g_return_if_fail(!errp || !*errp);

	handle_name=cmd_argv[0];

	handle_delete(handle_name,errp);
}
