/* $Id: cmd_help.c,v 1.5 2003/10/28 14:08:52 short Exp $
 * client cmdline interface command "help" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "cmd_help.h"	/* self */
#include "main.h"	/* for cmdline_command_table */


GQuark cmdline_cmd_help_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-help");

	return r;
}


const struct poptOption cmd_help_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_help(const char **cmd_argv,GError **errp)
{
const struct cmdline_command *commandp;
int cmd_name_maxlen;

	g_return_if_fail(!errp || !*errp);

	if (cmd_argv[0]) {
const char *cmd_help_argv[3];

		cmd_help_argv[0]=cmd_argv[0];
		cmd_help_argv[1]="--help";
		cmd_help_argv[2]=NULL;
		invoke_cmd(2,cmd_help_argv);
		return;
		}

	cmd_name_maxlen=0;
	for (commandp=cmdline_command_table+1;commandp->name;commandp++)
		cmd_name_maxlen=MAX(cmd_name_maxlen,(int)strlen(commandp->name));
	for (commandp=cmdline_command_table+1;commandp->name;commandp++)
		printf("%-*s\t%s\n",cmd_name_maxlen,commandp->name,_(commandp->description));
}
