/* $Id: cmd_lcd.c,v 1.5 2003/12/13 21:20:05 short Exp $
 * client cmdline interface command "lcd" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <glib/gstrfuncs.h>
#include <glib/gutils.h>
#include <glib/gmem.h>

#include "cmd_lcd.h"	/* self */
#include "main.h"	/* for CMDLINE_POPT_AUTOHELP */
#include "utf8.h"


const gchar *cmdline_cwd;


GQuark cmdline_cmd_lcd_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-lcd");

	return r;
}


const struct poptOption cmd_lcd_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_lcd(const char **cmd_argv,GError **errp)
{
gchar *currentdir_filename;

	g_return_if_fail(!errp || !*errp);

	if (cmd_argv[0]) {
		if (chdir(CMD_FILENAME_FROM_UTF8_ALLOCA(cmd_argv[0]))) {
			g_set_error(errp,CMDLINE_CMD_LCD_ERROR,CMDLINE_CMD_LCD_ERROR_CANNOT_CHANGE_HOSTOS_DIRECTORY,
					_("Cannot change host-os directory to '%s': %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(cmd_argv[0]),g_strerror(errno));
			return;
			}
		}

	currentdir_filename=g_get_current_dir();
	printf("Host-OS CWD: %s\n",CMD_LOCALE_FROM_UTF8_ALLOCA(CMD_FILENAME_TO_UTF8_ALLOCA(currentdir_filename)));
	g_free(currentdir_filename);
}
