/* $Id: cmd_ls.c,v 1.6 2006/01/01 07:24:34 lace Exp $
 * client cmdline interface command "ls" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <string.h>
#include <captive/client-directory.h>

#include "cmd_ls.h"	/* self */
#include "cmd_cd.h"	/* for cmdline_path_from_cwd() */
#include "main.h"
#include "file_info.h"
#include "utf8.h"


GQuark cmdline_cmd_ls_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-ls");

	return r;
}


const struct poptOption cmd_ls_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_ls(const char **cmd_argv,GError **errp)
{
CaptiveDirectoryObject *captive_directory_object;
CaptiveFileInfoObject *captive_file_info_object;
GnomeVFSResult errvfsresult;
const gchar *targetdir;

	g_return_if_fail(!errp || !*errp);

	targetdir=cmdline_path_from_cwd(cmd_argv[0]);

	if (!errvfsresult_to_gerr(errp,captive_directory_new_open(
			&captive_directory_object,	/* captive_directory_object_return */
			cmdline_captive_vfs_object,	/* captive_vfs_object */
			targetdir))) {	/* pathname */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_LS_ERROR,CMDLINE_CMD_LS_ERROR_CANNOT_OPEN_DIRECTORY,
				_("Cannot open directory: %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(targetdir));
		return;
		}

	while (GNOME_VFS_OK==(errvfsresult=captive_directory_read(
			captive_directory_object,	/* captive_directory_object */
			&captive_file_info_object))) {	/* captive_file_info_object_return */
		cmdline_captive_file_info_object_dump_line(captive_file_info_object,errp);
		g_object_unref(captive_file_info_object);
		if (*errp)
			goto err_unref;
		}
	if (GNOME_VFS_ERROR_EOF!=errvfsresult) {
gboolean errbool;

		errbool=errvfsresult_to_gerr(errp,errvfsresult);
		g_assert(errbool==FALSE);
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_LS_ERROR,CMDLINE_CMD_LS_ERROR_READING_DIRECTORY,
				_("Error reading directory: %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(targetdir));
		goto err_unref;
		}

err_unref:
	g_object_unref(captive_directory_object);
}
