/* $Id: cmd_mkdir.c,v 1.4 2003/12/13 21:20:05 short Exp $
 * client cmdline interface command "mkdir" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <captive/client-directory.h>

#include "cmd_mkdir.h"	/* self */
#include "cmd_cd.h"	/* for cmdline_path_from_cwd() */
#include "main.h"
#include "utf8.h"


GQuark cmdline_cmd_mkdir_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-mkdir");

	return r;
}


const struct poptOption cmd_mkdir_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_mkdir(const char **cmd_argv,GError **errp)
{
CaptiveDirectoryObject *captive_directory_object;
guint perms=0755;
const gchar *targetdir;

	g_return_if_fail(!errp || !*errp);

	targetdir=cmdline_path_from_cwd(cmd_argv[0]);

	if (!errvfsresult_to_gerr(errp,captive_directory_new_make(
			&captive_directory_object,	/* captive_directory_object_return */
			cmdline_captive_vfs_object,	/* captive_vfs_object */
			targetdir,	/* pathname */
			perms))) {	/* perms */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_MKDIR_ERROR,CMDLINE_CMD_MKDIR_ERROR_CANNOT_CREATE_DIRECTORY,
				_("Cannot create directory: %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(targetdir));
		return;
		}

	g_object_unref(captive_directory_object);
}
