/* $Id: cmd_mv.c,v 1.4 2003/12/13 21:20:05 short Exp $
 * client cmdline interface command "mv" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the temvs of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <captive/client-file.h>

#include "cmd_mv.h"	/* self */
#include "cmd_cd.h"	/* for cmdline_path_from_cwd() */
#include "main.h"
#include "utf8.h"


GQuark cmdline_cmd_mv_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-mv");

	return r;
}


const struct poptOption cmd_mv_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_mv(const char **cmd_argv,GError **errp)
{
CaptiveFileObject *captive_file_object;
const gchar *sourcefile,*targetfile;

	g_return_if_fail(!errp || !*errp);

	sourcefile=cmdline_path_from_cwd(cmd_argv[0]);
	targetfile=cmdline_path_from_cwd(cmd_argv[1]);

	if (!errvfsresult_to_gerr(errp,captive_file_new_open(
			&captive_file_object,	/* captive_file_object_return */
			cmdline_captive_vfs_object,	/* captive_vfs_object */
			sourcefile,	/* pathname */
			GNOME_VFS_OPEN_NONE))) {	/* mode */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_MV_ERROR,CMDLINE_CMD_MV_ERROR_CANNOT_OPEN_FILE_TO_MOVE,
				_("Cannot open file to be moved: %s"),CMD_LOCALE_FROM_UTF8_ALLOCA(targetfile));
		return;
		}

	if (!errvfsresult_to_gerr(errp,captive_file_move(
			captive_file_object,	/* captive_file_object_old */
			targetfile,	/* pathname_new */
			FALSE))) {	/* force_replace */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_MV_ERROR,CMDLINE_CMD_MV_ERROR_CANNOT_MOVE_FILE,
				_("Cannot move file '%s' to its target name '%s'"),
				CMD_LOCALE_FROM_UTF8_ALLOCA(sourcefile),CMD_LOCALE_FROM_UTF8_ALLOCA(targetfile));
		goto err_unref;
		}

err_unref:
	g_object_unref(captive_file_object);
}
