/* $Id: cmd_open.c,v 1.2 2003/12/13 21:20:05 short Exp $
 * client cmdline interface command "open" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <captive/client-file.h>

#include "cmd_open.h"	/* self */
#include "cmd_cd.h"	/* for cmdline_path_from_cwd() */
#include "main.h"
#include "handle.h"
#include "utf8.h"


GQuark cmdline_cmd_open_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-open");

	return r;
}


static int optarg_read;
static int optarg_write;
static int optarg_random;

const struct poptOption cmd_open_table[]={
		CMDLINE_POPT("read",'r',POPT_ARG_NONE,&optarg_read,
				N_("Open file with 'GNOME_VFS_OPEN_READ' disposition flag"),NULL),
		CMDLINE_POPT("write",'w',POPT_ARG_NONE,&optarg_write,
				N_("Open file with 'GNOME_VFS_OPEN_WRITE' disposition flag"),NULL),
		CMDLINE_POPT("random",'R',POPT_ARG_NONE,&optarg_random,
				N_("Open file with 'GNOME_VFS_OPEN_RANDOM' disposition flag"),NULL),
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_open(const char **cmd_argv,GError **errp)
{
CaptiveFileObject *captive_file_object;
const gchar *filename;
GnomeVFSOpenMode mode;
const gchar *handle_name;

	g_return_if_fail(!errp || !*errp);

	handle_name=cmd_argv[0];
	filename=cmdline_path_from_cwd(cmd_argv[1]);
	mode=0
			| (!optarg_read   ? 0 : GNOME_VFS_OPEN_READ)
			| (!optarg_write  ? 0 : GNOME_VFS_OPEN_WRITE)
			| (!optarg_random ? 0 : GNOME_VFS_OPEN_RANDOM);
	optarg_read=0;
	optarg_write=0;
	optarg_random=0;

	if (!handle_check_not_used(handle_name,errp))
		return;

	if (!errvfsresult_to_gerr(errp,captive_file_new_open(
			&captive_file_object,	/* captive_file_object_return */
			cmdline_captive_vfs_object,	/* captive_vfs_object */
			filename,	/* pathname */
			mode))) {	/* mode */
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_OPEN_ERROR,CMDLINE_CMD_OPEN_ERROR_OPENING_FILE,
				_("Error opening guest-os file '%s'"),CMD_LOCALE_FROM_UTF8_ALLOCA(filename));
		return;
		}

	handle_set(handle_name,captive_file_object);
	g_object_unref(captive_file_object);
}
