/* $Id: cmd_put.h,v 1.3 2003/10/28 14:06:14 short Exp $
 * Include file for client cmdline interface command "put" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_CMDLINE_CMD_PUT_H
#define _CAPTIVE_CLIENT_CMDLINE_CMD_PUT_H 1


#include <glib/gerror.h>
#include <popt.h>


#define CMDLINE_CMD_PUT_ERROR (cmdline_cmd_put_error_quark())
GQuark cmdline_cmd_put_error_quark(void);

typedef enum {
	CMDLINE_CMD_PUT_ERROR_OPENING_SOURCE_FILE,
	CMDLINE_CMD_PUT_ERROR_CANNOT_CREATE_TARGET_GUESTOS_FILE,
	CMDLINE_CMD_PUT_ERROR_WRITING_TARGET_GUESTOS_FILE,
	CMDLINE_CMD_PUT_ERROR_READING_SOURCE_FILE,
	CMDLINE_CMD_PUT_ERROR_CLOSING_SOURCE_FILE,
	CMDLINE_CMD_PUT_ERROR_PARSING_TRANSFER_BUFFER_SIZE
	} CmdlineCmdPutError;


extern const struct poptOption cmd_put_table[];

void cmd_put(const char **cmd_argv,GError **errp);


#endif /* _CAPTIVE_CLIENT_CMDLINE_CMD_PUT_H */
