/* $Id: cmd_quit.c,v 1.3 2003/10/28 14:08:52 short Exp $
 * client cmdline interface command "quit" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <glib-object.h>

#include "cmd_quit.h"	/* self */
#include "main.h"


GQuark cmdline_cmd_quit_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-quit");

	return r;
}


const struct poptOption cmd_quit_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_quit(const char **cmd_argv,GError **errp)
{
	g_return_if_fail(!errp || !*errp);

	main_exit();
}
