/* $Id: cmd_shell.c,v 1.6 2003/10/28 17:44:22 short Exp $
 * client cmdline interface command "shell" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <glib/gstrfuncs.h>
#include <glib/gmem.h>
#include <string.h>

#ifdef HAVE_LIBREADLINE
#include <readline/readline.h>
#ifdef HAVE_READLINE_HISTORY_H
#include <readline/history.h>
#endif /* HAVE_READLINE_HISTORY_H */
#endif /* HAVE_LIBREADLINE */

#include "cmd_shell.h"	/* self */
#include "cmd_quit.h"	/* for cmd_quit() */
#include "main.h"	/* for invoke_cmd() */
#include "cmd_cd.h"


/* Config: */
#define PROMPT_STRING "%s$ "	/* %s == 'cmdline_cwd' */


GQuark cmdline_cmd_shell_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-shell");

	return r;
}


const struct poptOption cmd_shell_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


/* Function mostly stolen from the project Partition Surprise.
 */
void cmd_shell(const char **cmd_argv,GError **errp)
{
char *line;
#ifndef HAVE_LIBREADLINE
char linebuf[1024],*s;
#endif /* HAVE_LIBREADLINE */
int errint,line_argc;
const char **line_argv=NULL;
gchar *prompt;
const char *cmd_cd_args[]={NULL};

	g_return_if_fail(!errp || !*errp);

#ifndef HAVE_LIBREADLINE
	puts(_("Line editing not available, please recompile with readline library installed"));
#endif /* HAVE_LIBREADLINE */

	cmd_cd(cmd_cd_args,errp);	/* Show current directory. */
	if (errp && *errp)
		return;

	for (;;) {
		prompt=g_strdup_printf(PROMPT_STRING,cmdline_cwd);
#ifdef HAVE_LIBREADLINE
		line=readline(prompt);
#ifdef HAVE_ADD_HISTORY
		if (line && *line)
			add_history(line);
#endif /* HAVE_ADD_HISTORY */
#else /* HAVE_LIBREADLINE */
		fputs(prompt,stdout); fflush(stdout);
		line=fgets(linebuf,sizeof(linebuf),stdin);
#endif /* HAVE_LIBREADLINE */
		g_free(prompt);
		if (!line) {
			cmd_quit(
					NULL,	/* cmd_argv */
					errp);	/* errp */
			g_assert_not_reached();
			}
#ifndef HAVE_LIBREADLINE
		if (line && (s=strchr(line,'\n')))
			*s='\0';
#endif /* HAVE_LIBREADLINE */

		line_argv=NULL;
		errint=poptParseArgvString(line,&line_argc,&line_argv);
#ifdef HAVE_LIBREADLINE
		free(line);
#endif /* HAVE_LIBREADLINE */
		if (errint!=0) {
			free(line_argv);
			g_set_error(errp,CMDLINE_CMD_SHELL_ERROR,CMDLINE_CMD_SHELL_ERROR_LINE_PARSE_ARGUMENTS,
					_("Error '%s' parsing arguments of text line: %s"),poptStrerror(errint),line);
			err_cleanup(errp);
			continue;
			}

		invoke_cmd(line_argc,line_argv);	/* errors catched inside */
		free(line_argv);
		}
}
