/* $Id: cmd_volume.c,v 1.2 2003/10/28 14:08:52 short Exp $
 * client cmdline interface command "volume" for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <popt.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "captive/client-vfs.h"

#include "cmd_volume.h"	/* self */
#include "main.h"


GQuark cmdline_cmd_volume_error_quark(void)
{
GQuark r=0;

	if (!r)
		r=g_quark_from_static_string("cmdline-cmd-volume");

	return r;
}


const struct poptOption cmd_volume_table[]={
		CMDLINE_POPT_AUTOHELP
		POPT_TABLEEND
		};


void cmd_volume(const char **cmd_argv,GError **errp)
{
CaptiveVfsVolumeInfo captive_vfs_volume_info;

	g_return_if_fail(!errp || !*errp);

	if (!errvfsresult_to_gerr(errp,captive_vfs_volume_info_get(cmdline_captive_vfs_object,&captive_vfs_volume_info))) {
		err_cleanup(errp);
		g_set_error(errp,CMDLINE_CMD_VOLUME_ERROR,CMDLINE_CMD_VOLUME_ERROR_CANNOT_GET_VOLUME_INFO,
				_("Failed to get volume info"));
		return;
		}

	printf("Block size: 0x%lX\n",(unsigned long)captive_vfs_volume_info.block_size);
	printf("Total bytes: %" G_GUINT64_FORMAT "\n",captive_vfs_volume_info.bytes);
	printf("Bytes free total: %" G_GUINT64_FORMAT "\n",captive_vfs_volume_info.bytes_free);
	printf("Bytes free without reserved: %" G_GUINT64_FORMAT "\n",captive_vfs_volume_info.bytes_available);
}
