/* $Id: handle.h,v 1.1 2003/11/10 08:54:30 short Exp $
 * Include file for client cmdline named CaptiveFileObject storage for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_CMDLINE_HANDLE_H
#define _CAPTIVE_CLIENT_CMDLINE_HANDLE_H 1


#include <glib/gerror.h>
#include <captive/client-file.h>


#define CMDLINE_HANDLE_ERROR (cmdline_handle_error_quark())
GQuark cmdline_handle_error_quark(void);

typedef enum {
	CMDLINE_HANDLE_ERROR_LOOKUP,
	CMDLINE_HANDLE_ERROR_ALREADY_USED,
	CMDLINE_HANDLE_ERROR_DELETE
	} CmdlineHandleError;


CaptiveFileObject *handle_get(const gchar *handle_name,GError **errp);
/* Returns: TRUE if not used. */
gboolean handle_check_not_used(const gchar *handle_name,GError **errp);
void handle_set(const gchar *handle_name,CaptiveFileObject *captive_file_object);
void handle_delete(const gchar *handle_name,GError **errp);


#endif /* _CAPTIVE_CLIENT_CMDLINE_FILE_INFO_H */
