/* $Id: main.h,v 1.5 2003/10/28 14:04:48 short Exp $
 * Include file for client cmdline interface control functions for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_CMDLINE_MAIN_H
#define _CAPTIVE_CLIENT_CMDLINE_MAIN_H 1


#include <glib/gtypes.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <captive/client-vfs.h>


#define CMDLINE_POPT(longname,shortname,argInfoP,argP,descripP,argDescripP) \
		{ \
			longName: (longname), \
			shortName: (shortname), \
			argInfo: (argInfoP), \
			arg: (void *)argP, \
			val: 0, \
			descrip: (descripP), \
			argDescrip: (argDescripP), \
		}
extern const struct poptOption cmdline_poptHelpOptions[];
#define CMDLINE_POPT_AUTOHELP \
		{ NULL,'\0',POPT_ARG_INCLUDE_TABLE,(struct poptOption *)cmdline_poptHelpOptions,0,"Help options:",NULL },


#define CMDLINE_MAIN_ERROR (cmdline_main_error_quark())
GQuark cmdline_main_error_quark(void);

typedef enum {
	CMDLINE_MAIN_ERROR_UNKNOWN_COMMAND,
	CMDLINE_MAIN_ERROR_INVALID_COMMAND_ARGUMENTS,
	CMDLINE_MAIN_ERROR_READING_COMMAND_CONFIG,
	CMDLINE_MAIN_ERROR_EXCEEDING_COMMAND_OPTION,
	CMDLINE_MAIN_ERROR_INVALID_COMMAND_ARGUMENT_COUNT,
	CMDLINE_MAIN_ERROR_GENERIC_ERROR
	} CmdlineMainError;


struct cmdline_command {
	const gchar *name,*description;
	const struct poptOption *table;
	void (*func)(const char **cmd_argv,GError **errp);
	gint argsn_min,argsn_max;
	};

extern const struct cmdline_command cmdline_command_table[];


extern CaptiveVfsObject *cmdline_captive_vfs_object;


void invoke_cmd(int cmd_argc,const char **cmd_argv);
void err_cleanup(GError **errp);
gboolean errvfsresult_to_gerr(GError **errp,GnomeVFSResult errvfsresult);
void main_exit(void);


#endif /* _CAPTIVE_CLIENT_CMDLINE_MAIN_H */
