/* $Id: utf8.c,v 1.3 2005/12/16 11:44:08 short Exp $
 * client cmdline interface GnomeVFSFileInfo utils for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <glib/gunicode.h>	/* for g_get_charset() */


#include "utf8.h"	/* self */


gchar *cmd_utf8_macro_malloc_errorchecking(
		gchar *(*func)(const gchar *string,gssize len,gsize *bytes_read,gsize *bytes_written,GError **error),
		const gchar *func_name,
		const gchar *string)
{
GError *error;
gchar *r;

	g_return_val_if_fail(func!=NULL,NULL);
	g_return_val_if_fail(string!=NULL,NULL);

	error=NULL;
	r=(*func)(
			string,	/* opsysstring/utf8string */
			-1,	/* len; '\0'-terminated */
			NULL,	/* bytes_read */
			NULL,	/* bytes_written */
			&error);	/* error */
	if (error) {
const gchar *charset;

		g_get_charset(&charset);
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_WARNING,"captivefs %s(): name=\"%s\"; g_get_charset()=\"%s\", %s: %s",
				func_name,string,charset,
				_("fix environment variables - locale(7), mount(8) and locale(1) commands \"locale\" and \"locale -a\""),
				error->message);
		g_clear_error(&error);
		}
	return r;
}
