/* $Id: utf8.h,v 1.2 2004/08/26 10:24:51 short Exp $
 * Include file for client cmdline interface GnomeVFSFileInfo utils for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_CMDLINE_UTF8_H
#define _CAPTIVE_CLIENT_CMDLINE_UTF8_H 1


#include <captive/macros.h>
#include <glib/gconvert.h>
#include <glib/gtypes.h>


gchar *cmd_utf8_macro_malloc_errorchecking(
		gchar *(*func)(const gchar *string,gssize len,gsize *bytes_read,gsize *bytes_written,GError **error),
		const gchar *func_name,
		const gchar *string);


#define CMD_UTF8_MACRO_ALLOCA(func,string) ({ \
		const gchar *_cmd_utf8_macro_alloca_string=(string); \
		gchar *_cmd_utf8_macro_alloca_r_malloc; \
		const gchar *_cmd_utf8_macro_alloca_r; \
		 \
		_cmd_utf8_macro_alloca_r_malloc=cmd_utf8_macro_malloc_errorchecking( \
				func, \
				G_STRINGIFY(func), \
				_cmd_utf8_macro_alloca_string); \
		if (!_cmd_utf8_macro_alloca_r_malloc) \
			_cmd_utf8_macro_alloca_r=_cmd_utf8_macro_alloca_string; \
		else { \
			_cmd_utf8_macro_alloca_r=captive_strdup_alloca(_cmd_utf8_macro_alloca_r_malloc); \
			g_free(_cmd_utf8_macro_alloca_r_malloc); \
			} \
		_cmd_utf8_macro_alloca_r; \
		})


#define CMD_FILENAME_TO_UTF8_ALLOCA(string)   CMD_UTF8_MACRO_ALLOCA(g_filename_to_utf8,(string))
#define CMD_FILENAME_FROM_UTF8_ALLOCA(string) CMD_UTF8_MACRO_ALLOCA(g_filename_from_utf8,(string))
#define CMD_LOCALE_TO_UTF8_ALLOCA(string)     CMD_UTF8_MACRO_ALLOCA(g_locale_to_utf8,(string))
#define CMD_LOCALE_FROM_UTF8_ALLOCA(string)   CMD_UTF8_MACRO_ALLOCA(g_locale_from_utf8,(string))


#endif /* _CAPTIVE_CLIENT_CMDLINE_UTF8_H */
