/* $Id: gnomevfsresult.c,v 1.4 2006/01/02 02:32:32 lace Exp $
 * Client fuse interface handling of 'GnomeVFSResult' for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <libgnomevfs/gnome-vfs-result.h>
#include <glib/ghash.h>
#include <glib/gmessages.h>
#include <errno.h>
#include <stdio.h>

#include "gnomevfsresult.h"	/* self */


/* Config: */
#define ERRNO_VALUE_MAX 0x400


/* map: GINT_TO_POINTER(GnomeVFSResult) -> GINT_TO_POINTER(errno) */
static GHashTable *gnomevfsresult_to_errno_hash;

static void gnomevfsresult_to_errno_hash_init(void)
{
int errno_i;

	if (gnomevfsresult_to_errno_hash)
		return;
	gnomevfsresult_to_errno_hash=g_hash_table_new(g_direct_hash,g_direct_equal);
	for (errno_i=1;errno_i<ERRNO_VALUE_MAX;errno_i++) {
GnomeVFSResult gnomevfsresult;

		/* gnome_vfs_result_from_errno_code() returns 'GNOME_VFS_ERROR_GENERIC'
		 * for invalid input values.
		 */
		gnomevfsresult=gnome_vfs_result_from_errno_code(errno_i);
		if (GNOME_VFS_ERROR_GENERIC==gnomevfsresult)
			continue;
		g_hash_table_insert(
				gnomevfsresult_to_errno_hash,	/* hash_table */
				GINT_TO_POINTER(gnomevfsresult),	/* key */
				GINT_TO_POINTER(errno_i));	/* value */
		}
}

int gnomevfsresult_to_errno(GnomeVFSResult gnomevfsresult)
{
int r;

	g_return_val_if_fail(sizeof(GnomeVFSResult)<=sizeof(gint),EINVAL);

	/* 'GNOME_VFS_OK' may map to NULL or fallback somehow or whatever weird. */
	if (GNOME_VFS_OK==gnomevfsresult)
		return 0;

	gnomevfsresult_to_errno_hash_init();
	if (!(r=GPOINTER_TO_INT(g_hash_table_lookup(gnomevfsresult_to_errno_hash,GINT_TO_POINTER(gnomevfsresult))))) {
#if 0	/* Too many 'GnomeVFSResult's have no corresponding 'errno' value: */
		g_error(_("Unable to translate GnomeVFSResult %d back to errno"),(int)gnomevfsresult);
#endif
		return EINVAL;
		}
	return r;
}
