/* $Id: op_chmod.c,v 1.3 2006/01/22 17:38:25 lace Exp $
 * Client fuse interface operation "chmod" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-file.h>
#include <sys/stat.h>
#include <captive/macros.h>
#include <captive/client-file-info.h>

#include "op_chmod.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"
#include "utf8.h"


int op_chmod(const char *path,mode_t mode)
{
CaptiveFileObject *captive_file_object;
GnomeVFSResult errvfsresult;
CaptiveFileInfoObject *captive_file_info_object;

	g_return_val_if_fail(path!=NULL,-EINVAL);

	if (1
			&& !S_ISREG(mode)
			&& !S_ISDIR(mode))
		return -EPERM;

  path=CAPFUSE_FILENAME_TO_UTF8_ALLOCA(path);

	/* Do not: GNOME_VFS_OPEN_WRITE
	 * as we would get EPERM for setting back: chmod u+w
	 */
	if (GNOME_VFS_OK!=(errvfsresult=captive_file_new_open(&captive_file_object,capfuse_captive_vfs_object,path,0)))
		return -gnomevfsresult_to_errno(errvfsresult);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_info_object_new(&captive_file_info_object))) {
		g_object_unref(captive_file_object);
		return -gnomevfsresult_to_errno(errvfsresult);
		}

	captive_file_info_object->p.valid_fields=0
			|GNOME_VFS_FILE_INFO_FIELDS_PERMISSIONS
			|GNOME_VFS_FILE_INFO_FIELDS_ACCESS;
	captive_file_info_object->p.permissions=mode;
	errvfsresult=captive_file_file_info_set(captive_file_object,captive_file_info_object,GNOME_VFS_SET_FILE_INFO_PERMISSIONS);

	g_object_unref(captive_file_info_object);
	g_object_unref(captive_file_object);
	if (GNOME_VFS_OK!=errvfsresult)
		return -gnomevfsresult_to_errno(errvfsresult);

	return 0;
}
