/* $Id: op_opendir.c,v 1.2 2006/01/22 17:38:25 lace Exp $
 * Client fuse interface operation "opendir" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-directory.h>

#include "op_opendir.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"
#include "utf8.h"


int op_opendir(const char *path,struct fuse_file_info *fi)
{
CaptiveDirectoryObject *captive_directory_object;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(fi!=NULL,-EINVAL);
	g_return_val_if_fail(sizeof(fi->fh)==sizeof(unsigned long),-EINVAL);
	g_return_val_if_fail(sizeof(fi->fh)>=sizeof(CaptiveDirectoryObject *),-EINVAL);

  path=CAPFUSE_FILENAME_TO_UTF8_ALLOCA(path);

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_new_open(&captive_directory_object,capfuse_captive_vfs_object,path)))
		return -gnomevfsresult_to_errno(errvfsresult);

	fi->fh=(unsigned long)captive_directory_object;
	/* No data can change beneath FUSE. */
	fi->keep_cache=1;

	return 0;
}
