/* $Id: op_read.c,v 1.2 2005/12/19 20:27:44 lace Exp $
 * Client fuse interface operation "read" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-file.h>

#include "op_read.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"


int op_read(const char *path,char *buf,size_t size,off_t off,struct fuse_file_info *fi)
{
CaptiveFileObject *captive_file_object;
GnomeVFSResult errvfsresult;
GnomeVFSFileSize bytes_read;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(buf!=NULL,-EINVAL);
	g_return_val_if_fail(size>0,-EINVAL);
	g_return_val_if_fail(off>=0,-EINVAL);
	g_return_val_if_fail(fi!=NULL,-EINVAL);

	captive_file_object=(gpointer)fi->fh;
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),-EINVAL);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_seek(captive_file_object,GNOME_VFS_SEEK_START,off)))
		return -gnomevfsresult_to_errno(errvfsresult);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_read(captive_file_object,buf,size,&bytes_read)))
		return -gnomevfsresult_to_errno(errvfsresult);

	return bytes_read;
}
