/* $Id: op_readdir.c,v 1.4 2006/01/22 17:38:25 lace Exp $
 * Client fuse interface operation "readdir" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-directory.h>
#include <captive/macros.h>

#include "op_readdir.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"
#include "capfuse_captive_file_info_object.h"
#include "utf8.h"


/* int (*fuse_fill_dir_t)(void *buf,const char *name,const struct stat *stbuf,off_t off); */

int op_readdir(const char *path,void *buf,fuse_fill_dir_t fill_dir,off_t off,struct fuse_file_info *fi)
{
CaptiveDirectoryObject *captive_directory_object;
GnomeVFSResult errvfsresult;
CaptiveFileInfoObject *captive_file_info_object;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(fill_dir!=NULL,-EINVAL);
	g_return_val_if_fail(fi!=NULL,-EINVAL);

	captive_directory_object=(gpointer)fi->fh;
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),-EINVAL);

	while (GNOME_VFS_OK==(errvfsresult=captive_directory_read(
			captive_directory_object,	/* captive_directory_object */
			&captive_file_info_object))) {	/* captive_file_info_object */
struct stat stat;
int errint;
char *captive_file_info_object_name;

		errint=capfuse_captive_file_info_object_to_stat(&stat,captive_file_info_object);
		if (errint) {
			g_object_unref(captive_file_info_object);
			return errint;
			}
		captive_file_info_object_name=capfuse_filename_from_utf8_malloc_errorchecking(captive_file_info_object->p.name);
		errint=(*fill_dir)(
				buf,	/* buf; opaque */
				(captive_file_info_object_name ? captive_file_info_object_name : captive_file_info_object->p.name),	/* name */
				&stat,	/* stbuf */
				0);	/* off; operation mode 1 - <fuse.h>/(*readdir) */
		g_free(captive_file_info_object_name);	/* may be NULL */
		/* WARNING: (*fill_dir) needs: *captive_file_info_object->p.name */
		g_object_unref(captive_file_info_object);
		if (errint) {
			/* FIXME: Is it right? Examples do so. */
			break;
			}
		}
	if (GNOME_VFS_ERROR_EOF!=errvfsresult)
		return -gnomevfsresult_to_errno(errvfsresult);

	return 0;
}
