/* $Id: op_releasedir.c,v 1.1 2005/12/19 18:55:12 lace Exp $
 * Client fuse interface operation "releasedir" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-directory.h>

#include "op_releasedir.h"	/* self */
#include "main.h"


int op_releasedir(const char *path,struct fuse_file_info *fi)
{
CaptiveDirectoryObject *captive_directory_object;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(fi!=NULL,-EINVAL);

	captive_directory_object=(gpointer)fi->fh;
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),-EINVAL);

	g_object_unref(captive_directory_object);

	return 0;
}
