/* $Id: op_rename.c,v 1.2 2006/01/22 17:38:25 lace Exp $
 * Client fuse interface operation "rename" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-file.h>
#include <sys/stat.h>

#include "op_rename.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"
#include "utf8.h"


int op_rename(const char *oldpath,const char *newpath)
{
CaptiveFileObject *captive_file_object;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(oldpath!=NULL,-EINVAL);
	g_return_val_if_fail(newpath!=NULL,-EINVAL);

  oldpath=CAPFUSE_FILENAME_TO_UTF8_ALLOCA(oldpath);
  newpath=CAPFUSE_FILENAME_TO_UTF8_ALLOCA(newpath);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_new_open(&captive_file_object,capfuse_captive_vfs_object,oldpath,
			GNOME_VFS_OPEN_WRITE|GNOME_VFS_OPEN_RANDOM)))
		return -gnomevfsresult_to_errno(errvfsresult);

	/* Do not: FALSE==force_replace
	 * as it would really return EEXIST on mv(1) over an existing file.
	 */
	errvfsresult=captive_file_move(
			captive_file_object,	/* captive_file_object_old */
			newpath,	/* pathname_new */
			TRUE);	/* force_replace */

	g_object_unref(captive_file_object);
	if (GNOME_VFS_OK!=errvfsresult)
		return -gnomevfsresult_to_errno(errvfsresult);
	return 0;
}
