/* $Id: op_statfs.c,v 1.2 2005/12/19 18:54:32 lace Exp $
 * Client fuse interface operation "statfs" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <sys/statfs.h>
#include <fuse.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <errno.h>
#include <captive/client-vfs.h>

#include "op_statfs.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"


int op_statfs(const char *path,struct statfs *stbuf)
{
CaptiveVfsVolumeInfo volume_info;
GnomeVFSResult errvfsresult;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(stbuf!=NULL,-EINVAL);

	if (GNOME_VFS_OK!=(errvfsresult=captive_vfs_volume_info_get(capfuse_captive_vfs_object,&volume_info)))
		return -gnomevfsresult_to_errno(errvfsresult);

	/* <fuse.h>: The 'f_type' and 'f_fsid' fields are ignored */
	stbuf->f_bsize  =volume_info.block_size;
	/* Some rounding? Which way? */
	stbuf->f_blocks =volume_info.bytes          /volume_info.block_size;
	stbuf->f_bfree  =volume_info.bytes_free     /volume_info.block_size;
	stbuf->f_bavail =volume_info.bytes_available/volume_info.block_size;
	stbuf->f_files  =0;
	stbuf->f_ffree  =0;
	/* For NTFS: http://en.wikipedia.org/wiki/Comparison_of_file_systems */
	stbuf->f_namelen=255;
	return 0;
}
