/* $Id: op_utime.c,v 1.4 2006/01/22 17:38:25 lace Exp $
 * Client fuse interface operation "utime" for libcaptive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <fuse.h>
#include <errno.h>
#include <captive/client-file.h>
#include <sys/stat.h>
#include <captive/macros.h>
#include <time.h>
#include <captive/client-file-info.h>

#include "op_utime.h"	/* self */
#include "main.h"
#include "gnomevfsresult.h"
#include "capfuse_captive_file_info_object.h"
#include "utf8.h"


int op_utime(const char *path,struct utimbuf *buf)
{
CaptiveFileObject *captive_file_object;
GnomeVFSResult errvfsresult;
CaptiveFileInfoObject *captive_file_info_object;

	g_return_val_if_fail(path!=NULL,-EINVAL);
	g_return_val_if_fail(buf!=NULL,-EINVAL);
	g_return_val_if_fail(buf->actime!=0,-EINVAL);
	g_return_val_if_fail(buf->modtime!=0,-EINVAL);

  path=CAPFUSE_FILENAME_TO_UTF8_ALLOCA(path);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_new_open(&captive_file_object,capfuse_captive_vfs_object,path,
			GNOME_VFS_OPEN_WRITE|GNOME_VFS_OPEN_RANDOM)))
		return -gnomevfsresult_to_errno(errvfsresult);

	if (GNOME_VFS_OK!=(errvfsresult=captive_file_info_object_new(&captive_file_info_object))) {
		g_object_unref(captive_file_object);
		return -gnomevfsresult_to_errno(errvfsresult);
		}

	captive_file_info_object->p.valid_fields=0
			|GNOME_VFS_FILE_INFO_FIELDS_ATIME
			|GNOME_VFS_FILE_INFO_FIELDS_MTIME
			|GNOME_VFS_FILE_INFO_FIELDS_CTIME;
	captive_file_info_object->p.atime=buf->actime;
	captive_file_info_object->atime_nsec=0;
	captive_file_info_object->p.mtime=buf->modtime;
	captive_file_info_object->mtime_nsec=0;
	capfuse_timespec_split_get(&captive_file_info_object->p.ctime,&captive_file_info_object->ctime_nsec);
	/* Do not:  * It is probably not GnomeVFS compliant but still libcaptive compatible.
	 *          * GnomeVFS looks as assuming all the three fields set.
	 *          * GnomeVFS also does not check 'valid_fields' at all.
	 *         captive_file_info_object->p.ctime=0;	* Just sanity for sure. *
	 *         captive_file_info_object->p.valid_fields&=~GNOME_VFS_FILE_INFO_FIELDS_CTIME;
	 * as utime() syscall should really update 'ctime' to the current time.
	 */
	errvfsresult=captive_file_file_info_set(captive_file_object,captive_file_info_object,GNOME_VFS_SET_FILE_INFO_TIME);

	g_object_unref(captive_file_info_object);
	g_object_unref(captive_file_object);
	if (GNOME_VFS_OK!=errvfsresult)
		return -gnomevfsresult_to_errno(errvfsresult);

	return 0;
}
