/* $Id: utf8.c,v 1.3 2006/01/25 17:33:45 lace Exp $
 * FUSE interface module utf8 conversions for libcaptive
 * Copyright (C) 2003-2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "utf8.h"	/* self */
#include <glib/gmessages.h>
#include <glib/gerror.h>
#include <glib/gconvert.h>
#include <glib/gunicode.h>


char *capfuse_utf8_engine_malloc_errorchecking(const char *funcname,
		gchar *(*func)(const gchar *opsysstring,gssize len,gsize *bytes_read,gsize *bytes_written,GError **error),
		const char *string)
{
GError *error;
char *r;

	g_return_val_if_fail(string!=NULL,NULL);

	error=NULL;
	r=(*func)(
			string,	/* g_filename_to_utf8=>opsysstring || g_filename_from_utf8=>utf8string */
			-1,	/* len; '\0'-terminated */
			NULL,	/* bytes_read */
			NULL,	/* bytes_written */
			&error);	/* error */
	g_assert(!r==!!error);
	if (error) {
const gchar *charset=NULL;

		g_get_charset(&charset);
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_WARNING,
				_("captive-FUSE %s(): string=\"%s\"; g_get_charset()=\"%s\": %s (see locale(7) and mount(8) environment variables)"),
				funcname,string,charset,error->message);
		g_clear_error(&error);
		}
	return r;
}
