/* $Id: utf8.h,v 1.2 2006/01/24 16:27:21 lace Exp $
 * Include file for FUSE interface module utf8 conversions for libcaptive
 * Copyright (C) 2002-2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_FUSE_UTF8_H
#define _CAPTIVE_CLIENT_FUSE_UTF8_H 1


#include <captive/macros.h>
#include <glib/gerror.h>


G_BEGIN_DECLS

char *capfuse_utf8_engine_malloc_errorchecking(const char *funcname,
		gchar *(*func)(const gchar *opsysstring,gssize len,gsize *bytes_read,gsize *bytes_written,GError **error),
		const char *string);

#define capfuse_filename_to_utf8_malloc_errorchecking(name) \
		capfuse_utf8_engine_malloc_errorchecking("g_filename_to_utf8",g_filename_to_utf8,(name))
#define capfuse_filename_from_utf8_malloc_errorchecking(name) \
		capfuse_utf8_engine_malloc_errorchecking("g_filename_from_utf8",g_filename_from_utf8,(name))

#define CAPFUSE_FILENAME_TO_UTF8_ALLOCA(name) ({ \
		const char *_capfuse_filename_to_utf8_alloca_name=(name); \
		char *_capfuse_filename_to_utf8_alloca_r_malloc; \
		const char *_capfuse_filename_to_utf8_alloca_r; \
		 \
		_capfuse_filename_to_utf8_alloca_r_malloc=capfuse_filename_to_utf8_malloc_errorchecking( \
				_capfuse_filename_to_utf8_alloca_name); \
		if (!_capfuse_filename_to_utf8_alloca_r_malloc) \
			_capfuse_filename_to_utf8_alloca_r=_capfuse_filename_to_utf8_alloca_name; \
		else { \
			_capfuse_filename_to_utf8_alloca_r=captive_strdup_alloca(_capfuse_filename_to_utf8_alloca_r_malloc); \
			g_free(_capfuse_filename_to_utf8_alloca_r_malloc); \
			} \
		_capfuse_filename_to_utf8_alloca_r; \
		})

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_FUSE_UTF8_H */
