/* $Id: gnome-vfs-module.c,v 1.6 2005/12/22 08:22:56 lace Exp $
 * gnome-vfs init/shutdown implementation of interface to libcaptive
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "gnome-vfs-method.h"
#include <libgnomevfs/gnome-vfs-module.h>
#include <glib/gmessages.h>
#include <glib/gutils.h>	/* for g_atexit() */

#include <captive/client.h>


/* filesystem-module-scope lock for _any_ libcaptive access */
G_LOCK_DEFINE(libcaptive);


static void vfs_module_shutdown_atexit(void);


/**
 * vfs_module_init:
 * @method_name: FIXME
 * @args: FIXME
 *
 * FIXME
 *
 * Returns: FIXME
 */
GnomeVFSMethod *vfs_module_init(const char *method_name,const char *args)
{
GnomeVFSMethod *captive_gnomevfs_method_ptr;

	g_return_val_if_fail(method_name!=NULL,NULL);
	g_return_val_if_fail(args!=NULL,NULL);	/* 'args' may be null if not supplied */

	captive_standalone_init();

	captive_gnomevfs_method_ptr=captive_gnomevfs_method_init(
			method_name,	/* method_name */
			args);	/* captive_args */

	g_atexit(vfs_module_shutdown_atexit);

	return captive_gnomevfs_method_ptr;
}


/**
 * vfs_module_shutdown:
 */
void vfs_module_shutdown(GnomeVFSMethod *method)
{
	/* 'method' may be NULL iff we are called from vfs_module_shutdown_atexit() */

	captive_gnomevfs_method_shutdown();
}


static void vfs_module_shutdown_atexit(void)
{
	vfs_module_shutdown(NULL);
}
