/* $Id: captivefs-misc.c,v 1.5 2005/12/16 11:44:08 short Exp $
 * lufs interface module misc functions for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captivefs-misc.h"	/* self */
#include <glib/gmessages.h>
#include "captivefs-vfs.h"

#include <captive/client-vfs.h>


/* module-scope lock for _any_ libcaptive access */
G_LOCK_DEFINE(libcaptive);


/* Resolve a link (if the info was not added to the dir cache when 
 * reading the parent dir)
 */
int captivefs_readlink(struct captivefs_vfs *captivefs_vfs,const char *link,char *buf,int buflen)
{
	g_return_val_if_fail(captivefs_vfs_validate(captivefs_vfs),-1);
	g_return_val_if_fail(link!=NULL,-1);
	g_return_val_if_fail(buf!=NULL,-1);
	g_return_val_if_fail(buflen>0,-1);

	if (captivefs_vfs->options.debug_messages)
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"captivefs_readlink: link=%s,buflen=%d",link,buflen);

	return -1;	/* unsupported by W32 */
}


/* Create a link
 */
int captivefs_link(struct captivefs_vfs *captivefs_vfs,const char *target,const char *lnk)
{
	g_return_val_if_fail(captivefs_vfs_validate(captivefs_vfs),-1);
	g_return_val_if_fail(target!=NULL,-1);
	g_return_val_if_fail(lnk!=NULL,-1);

	if (captivefs_vfs->options.debug_messages)
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"captivefs_link: target=%s,lnk=%s",target,lnk);

	return -1;	/* unsupported by W32 */
}


/* Create a symlink
 */
int captivefs_symlink(struct captivefs_vfs *captivefs_vfs,const char *target,const char *link)
{
	g_return_val_if_fail(captivefs_vfs_validate(captivefs_vfs),-1);
	g_return_val_if_fail(target!=NULL,-1);
	g_return_val_if_fail(link!=NULL,-1);

	if (captivefs_vfs->options.debug_messages)
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"captivefs_symlink: target=%s,link=%s",target,link);

	return -1;	/* unsupported by W32 */
}


char *captivefs_filename_to_utf8_malloc_errorchecking(const char *name)
{
GError *error;
char *r;

	g_return_val_if_fail(name!=NULL,NULL);

	error=NULL;
	r=g_filename_to_utf8(
			name,	/* opsysstring */
			-1,	/* len; '\0'-terminated */
			NULL,	/* bytes_read */
			NULL,	/* bytes_written */
			&error);	/* error */
	if (error) {
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_WARNING,
				_("captivefs %s(): name=\"%s\": %s (see locale(7) and mount(8) environment variables)"),
				"g_filename_to_utf8",name,error->message);
		g_clear_error(&error);
		}
	return r;
}


char *captivefs_filename_from_utf8_malloc_errorchecking(const char *name)
{
GError *error;
char *r;

	g_return_val_if_fail(name!=NULL,NULL);

	error=NULL;
	r=g_filename_from_utf8(
			name,	/* utf8string */
			-1,	/* len; '\0'-terminated */
			NULL,	/* bytes_read */
			NULL,	/* bytes_written */
			&error);	/* error */
	if (error) {
		g_log(G_LOG_DOMAIN,G_LOG_LEVEL_WARNING,"captivefs %s(): name=\"%s\"; g_get_charset()=\"%s\", %s: %s",
				"g_filename_from_utf8",name,charset,
				_("see environment variables - locale(7), mount(8) and locale(1) commands \"locale\" and \"locale -a\""),
				error->message);
		g_clear_error(&error);
		}
	return r;
}
