/* $Id: captivefs-misc.h,v 1.4 2003/12/13 21:20:05 short Exp $
 * Include file for lufs interface module misc functions for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_LUFS_CAPTIVEFS_MISC_H
#define _CAPTIVE_LUFS_CAPTIVEFS_MISC_H 1


#include <glib/gthread.h>
#include <captive/macros.h>


G_BEGIN_DECLS

G_LOCK_EXTERN(libcaptive);


char *captivefs_filename_to_utf8_malloc_errorchecking(const char *name);
char *captivefs_filename_from_utf8_malloc_errorchecking(const char *name);

#define CAPTIVEFS_FILENAME_TO_UTF8_ALLOCA(name) ({ \
		const char *_captivefs_filename_to_utf8_alloca_name=(name); \
		char *_captivefs_filename_to_utf8_alloca_r_malloc; \
		const char *_captivefs_filename_to_utf8_alloca_r; \
		 \
		_captivefs_filename_to_utf8_alloca_r_malloc=captivefs_filename_to_utf8_malloc_errorchecking( \
				_captivefs_filename_to_utf8_alloca_name); \
		if (!_captivefs_filename_to_utf8_alloca_r_malloc) \
			_captivefs_filename_to_utf8_alloca_r=_captivefs_filename_to_utf8_alloca_name; \
		else { \
			_captivefs_filename_to_utf8_alloca_r=captive_strdup_alloca(_captivefs_filename_to_utf8_alloca_r_malloc); \
			g_free(_captivefs_filename_to_utf8_alloca_r_malloc); \
			} \
		_captivefs_filename_to_utf8_alloca_r; \
		})

G_END_DECLS


#endif /* _CAPTIVE_LUFS_CAPTIVEFS_MISC_H */
