/* $Id: captivefs-vfs.h,v 1.3 2003/11/29 18:35:12 short Exp $
 * Include file for lufs interface module vfs objects implementation for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_LUFS_CAPTIVEFS_VFS_H
#define _CAPTIVE_LUFS_CAPTIVEFS_VFS_H 1


#include <glib/gtypes.h>
#include <captive/client-vfs.h>
#include <captive/options.h>
#include <sys/types.h>


G_BEGIN_DECLS

struct captivefs_vfs {
	CaptiveVfsObject *captive_vfs_object;
	struct captive_options options;
	gboolean private;
	pid_t parent_pid;
	struct captivefs_vfs **global_ctx;
	gint inits,mounts;
	};

gboolean captivefs_vfs_validate(struct captivefs_vfs *captivefs_vfs);

G_END_DECLS


#endif /* _CAPTIVE_LUFS_CAPTIVEFS_VFS_H */
