/* $Id$
 * Include file for cabextract - a program to extract Microsoft Cabinet files
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_INSTALL_ACQUIRE_CABEXTRACT_H
#define _CAPTIVE_INSTALL_ACQUIRE_CABEXTRACT_H 1


#include <glib/gtypes.h>


G_BEGIN_DECLS

typedef unsigned char  UBYTE; /* 8 bits exactly    */
typedef unsigned short UWORD; /* 16 bits (or more) */
typedef unsigned int   ULONG; /* 32 bits (or more) */
typedef   signed int    LONG; /* 32 bits (or more) */

struct cabinet {
  struct cabinet *next;                /* for making a list of cabinets  */
  struct acquire_cabinet *acquire_cabinet;
  const char  *filename;               /* input name of cabinet          */
  off_t filelen;                       /* length of cabinet file         */
  off_t blocks_off;                    /* offset to data blocks in file  */
  struct cabinet *prevcab, *nextcab;   /* multipart cabinet chains       */
  char *prevname, *nextname;           /* and their filenames            */
  char *previnfo, *nextinfo;           /* and their visible names        */
  struct folder *folders;              /* first folder in this cabinet   */
  struct file *files;                  /* first file in this cabinet     */
  UBYTE block_resv;                    /* reserved space in datablocks   */
  UBYTE flags;                         /* header flags                   */
};

struct file {
  struct file *next;                   /* next file in sequence          */
  struct folder *folder;               /* folder that contains this file */
  char *filename;                      /* output name of file            */
#if 0
  FILE *fh;                            /* open file handle or NULL       */
#endif
  ULONG length;                        /* uncompressed length of file    */
  ULONG offset;                        /* uncompressed offset in folder  */
  UWORD index;                         /* magic index number of folder   */
  UWORD time, date, attribs;           /* MS-DOS time/date/attributes    */
};

struct cabinet *find_cabs_in_file(struct acquire_cabinet *acquire_cabinet);
struct file *process_files(struct cabinet *basecab);
int extract_file(struct file *fi, int lower, int fix, char *dir);

G_END_DECLS


#endif /* _CAPTIVE_INSTALL_ACQUIRE_CABEXTRACT_H */
