/* $Id: cabinet-memory.c,v 1.1 2003/12/11 20:49:59 short Exp $
 * cabextract memory allocation for acquiration installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "cabinet-memory.h"	/* self */
#include <glib/gmessages.h>
#include <glib/ghash.h>
#include <glib/gtypes.h>
#include <glib/gslist.h>


struct _CaptiveAcquireCabinetMemoryObject {
	GObject parent_instance;

	/*< private >*/
	GHashTable *memory_hash;
	gpointer data;
	gsize data_size;
	};
struct _CaptiveAcquireCabinetMemoryObjectClass {
	GObjectClass parent_class;
	};

static CaptiveAcquireCabinetMemoryObject *memory_object;
static GSList *memory_object_slist;

static gpointer captive_acquire_cabinet_memory_object_parent_class=NULL;

static void captive_acquire_cabinet_memory_object_finalize_foreach
		(gpointer mem /* key */,gpointer mem_val,gpointer user_data /* unused */)
{
	g_return_if_fail(mem!=NULL);
	g_return_if_fail(mem_val!=NULL);
	g_return_if_fail(mem==mem_val);

	g_free(mem);
}

static void captive_acquire_cabinet_memory_object_finalize(CaptiveAcquireCabinetMemoryObject *memory)
{
	g_return_if_fail(memory!=NULL);
	g_return_if_fail(memory!=memory_object);

	g_hash_table_foreach(memory->memory_hash,
			captive_acquire_cabinet_memory_object_finalize_foreach,	/* func */
			NULL);	/* user_data; unused */

	g_hash_table_destroy(memory->memory_hash);

	g_free(memory->data);
	memory->data=NULL;
	memory->data_size=0;

	G_OBJECT_CLASS(captive_acquire_cabinet_memory_object_parent_class)->finalize((GObject *)memory);
}

static void captive_acquire_cabinet_memory_object_class_init(CaptiveAcquireCabinetMemoryObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_acquire_cabinet_memory_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_acquire_cabinet_memory_object_finalize;
}

static void captive_acquire_cabinet_memory_object_init(CaptiveAcquireCabinetMemoryObject *memory_object)
{
	memory_object->memory_hash=g_hash_table_new(g_direct_hash,g_direct_equal);
}

GType captive_acquire_cabinet_memory_object_get_type(void)
{
static GType captive_acquire_cabinet_memory_object_type=0;

	if (!captive_acquire_cabinet_memory_object_type) {
static const GTypeInfo captive_acquire_cabinet_memory_object_info={
				sizeof(CaptiveAcquireCabinetMemoryObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_acquire_cabinet_memory_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveAcquireCabinetMemoryObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_acquire_cabinet_memory_object_init,
				};

		captive_acquire_cabinet_memory_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptiveAcquireCabinetMemoryObject",&captive_acquire_cabinet_memory_object_info,0);
		}

	return captive_acquire_cabinet_memory_object_type;
}

CaptiveAcquireCabinetMemoryObject *acquire_cabinet_memory_object_new(void)
{
	return g_object_new(
			CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT,	/* object_type */
			NULL);	/* first_property_name */
}

void acquire_cabinet_memory_object_push(CaptiveAcquireCabinetMemoryObject *memory)
{
	g_return_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory));

	if (memory_object)
		memory_object_slist=g_slist_prepend(memory_object_slist,memory_object);
	memory_object=memory;
}

/* 'memory' is just a sanity check */
void acquire_cabinet_memory_object_pop(CaptiveAcquireCabinetMemoryObject *memory)
{
	g_return_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory));
	g_return_if_fail(memory==memory_object);

	if (!memory_object_slist)
		memory_object=NULL;
	else {
		memory_object=memory_object_slist->data;
		g_assert(memory_object!=NULL);
		memory_object_slist=g_slist_delete_link(memory_object_slist,memory_object_slist);
		}
}

gpointer acquire_cabinet_memory_malloc(gulong n_bytes)
{
gpointer r;

	g_return_val_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory_object),NULL);

	r=g_malloc(n_bytes);
	g_assert((!r)==(!n_bytes));
	if (r)
		g_hash_table_insert(memory_object->memory_hash,r,r);

	return r;
}

gpointer acquire_cabinet_memory_malloc0(gulong n_bytes)
{
gpointer r;

	g_return_val_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory_object),NULL);

	r=g_malloc0(n_bytes);
	g_assert((!r)==(!n_bytes));
	if (r)
		g_hash_table_insert(memory_object->memory_hash,r,r);

	return r;
}

gpointer acquire_cabinet_memory_realloc(gpointer mem,gulong n_bytes)
{
gpointer r;
gboolean errbool;

	g_return_val_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory_object),NULL);

	if (mem!=NULL) {
		errbool=g_hash_table_remove(memory_object->memory_hash,mem);
		g_assert(errbool==TRUE);
		}
	r=g_realloc(mem,n_bytes);
	g_assert((!r)==(!n_bytes));
	if (r)
		g_hash_table_insert(memory_object->memory_hash,r,r);

	return r;
}

void acquire_cabinet_memory_free(gpointer mem)
{
gboolean errbool;

	g_return_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory_object));

	if (mem!=NULL) {
		errbool=g_hash_table_remove(memory_object->memory_hash,mem);
		g_assert(errbool==TRUE);
		}
	g_free(mem);
}

/* UGLY HACK for 'cabextract/cabextract.c/decomp_state' */
gpointer acquire_cabinet_memory_data_get(gsize size)
{
	g_return_val_if_fail(size>0,NULL);
	g_return_val_if_fail(CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(memory_object),NULL);

	if (!memory_object->data_size) {
		memory_object->data_size=size;
		memory_object->data=g_malloc0(memory_object->data_size);
		}

	g_assert(memory_object->data_size==size);
	g_assert(memory_object->data!=NULL);

	return memory_object->data;
}
