/* $Id: cabinet-memory.h,v 1.1 2003/12/11 20:49:59 short Exp $
 * Include file for cabextract memory allocation for acquiration installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_INSTALL_ACQUIRE_CABINET_MEMORY_H
#define _CAPTIVE_INSTALL_ACQUIRE_CABINET_MEMORY_H 1


#include <glib/gtypes.h>
#include <glib-object.h>


G_BEGIN_DECLS

#define CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT            (captive_acquire_cabinet_memory_object_get_type())
#define CAPTIVE_ACQUIRE_CABINET_MEMORY_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT,CaptiveAcquireCabinetMemoryObject))
#define CAPTIVE_ACQUIRE_CABINET_MEMORY_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT,CaptiveAcquireCabinetMemoryObjectClass))
#define CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT))
#define CAPTIVE_ACQUIRE_CABINET_MEMORY_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT))
#define CAPTIVE_ACQUIRE_CABINET_MEMORY_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_ACQUIRE_CABINET_MEMORY_TYPE_OBJECT,CaptiveAcquireCabinetMemoryObjectClass))
typedef struct _CaptiveAcquireCabinetMemoryObject      CaptiveAcquireCabinetMemoryObject;
typedef struct _CaptiveAcquireCabinetMemoryObjectClass CaptiveAcquireCabinetMemoryObjectClass;


GType captive_acquire_cabinet_memory_object_get_type(void);

CaptiveAcquireCabinetMemoryObject *acquire_cabinet_memory_object_new(void);

void acquire_cabinet_memory_object_push(CaptiveAcquireCabinetMemoryObject *memory);
void acquire_cabinet_memory_object_pop(CaptiveAcquireCabinetMemoryObject *memory);

gpointer acquire_cabinet_memory_malloc (gulong n_bytes);
gpointer acquire_cabinet_memory_malloc0(gulong n_bytes);
gpointer acquire_cabinet_memory_realloc(gpointer mem,gulong n_bytes);
void     acquire_cabinet_memory_free   (gpointer mem);

gpointer acquire_cabinet_memory_data_get(gsize size);

G_END_DECLS


#endif /* _CAPTIVE_INSTALL_ACQUIRE_CABINET_MEMORY_H */
