/* $Id: cabinet.h,v 1.5 2003/12/11 20:49:59 short Exp $
 * Include file for drivers acquiring installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_INSTALL_ACQUIRE_CABINET_H
#define _CAPTIVE_INSTALL_ACQUIRE_CABINET_H 1


#include <glib/gtypes.h>
#include <libgnomevfs/gnome-vfs-file-size.h>
#include <libgnomevfs/gnome-vfs-handle.h>
#include "cabinet-memory.h"


G_BEGIN_DECLS

/* It is not 'GObject'-based as we will move to GnomeVFS handler cabextract://
 * anyway.
 */

struct acquire_cabinet {
	gpointer base;
	guint8 *base_cached;
	GnomeVFSFileOffset offset;
	GnomeVFSHandle **handlep;
	GnomeVFSFileSize size;
	const gchar *filename;
	GnomeVFSURI *uri;
	GnomeVFSURI *handle_uri;
	void (*seek)(struct acquire_cabinet *acquire_cabinet,GnomeVFSFileOffset offset);
	void (*seek_skip)(struct acquire_cabinet *acquire_cabinet,GnomeVFSFileOffset offset);
	GnomeVFSFileOffset (*tell)(struct acquire_cabinet *acquire_cabinet);
	GnomeVFSResult (*read)
			(struct acquire_cabinet *acquire_cabinet,gpointer buffer,GnomeVFSFileSize bytes,GnomeVFSFileSize *bytes_read);
	gint cabinet_done,cabinet_used;
	CaptiveAcquireCabinetMemoryObject *memory;	/* cabextract/cabextract.c memory leaks tracker */
	};

void acquire_cabinet_seek(struct acquire_cabinet *acquire_cabinet,GnomeVFSFileOffset offset);
void acquire_cabinet_seek_skip(struct acquire_cabinet *acquire_cabinet,GnomeVFSFileOffset offset);
GnomeVFSFileOffset acquire_cabinet_tell(struct acquire_cabinet *acquire_cabinet);
GnomeVFSResult acquire_cabinet_read
		(struct acquire_cabinet *acquire_cabinet,gpointer buffer,GnomeVFSFileSize bytes,GnomeVFSFileSize *bytes_read);

struct acquire_cabinet *acquire_cabinet_new_from_memory
		(gconstpointer file_base,size_t file_length,GnomeVFSURI *uri,gint cabinet_used);
struct acquire_cabinet *acquire_cabinet_new_from_handle
		(GnomeVFSHandle **handlep,GnomeVFSFileInfo *file_info,GnomeVFSURI *uri,gint cabinet_used);
void acquire_cabinet_free(struct acquire_cabinet *acquire_cabinet);
void acquire_cabinet_load(struct acquire_cabinet *acquire_cabinet);

G_END_DECLS


#endif /* _CAPTIVE_INSTALL_ACQUIRE_CABINET_H */
