/* $Id: diskscan.c,v 1.3 2003/11/20 06:19:31 short Exp $
 * W32 disk modules finder for acquiration installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <glib/gmessages.h>
#include <mntent.h>
#include <glib/ghash.h>
#include <glib/glist.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include "../libcaptive-install/proc_partitions.h"
#include "main.h"
#include <string.h>


/* Config: */
#define FILENAME_ETC_MTAB "/etc/mtab"


struct mod_uri_libntfs_proc_partitions_foreach_param {
	GHashTable *proc_partitions_ntfs_hash;
	GList *uri_list;	/* of (GnomeVFSURI *) */
	};

static void mod_uri_libntfs_proc_partitions_foreach(const gchar *device /* key */,const gchar *vol_name /* value */,
		struct mod_uri_libntfs_proc_partitions_foreach_param *foreach_param /* user_data */)
{
GnomeVFSURI *uri_device,*uri_libntfs;
static gboolean libntfs_warned=FALSE;

	g_return_if_fail(device!=NULL);
	g_return_if_fail(vol_name!=NULL);
	g_return_if_fail(foreach_param!=NULL);

	uri_libntfs=gnome_vfs_uri_new("libntfs:///");
	if (!uri_libntfs) {
		if (!libntfs_warned) {
			libntfs_warned=TRUE;
			g_warning(_("'libntfs' GnomeVFS method not supported; install package 'ntfsprogs-gnomevfs' >=%s"),"1.8.0beta2");
			}
		return;
		}
	g_assert(uri_libntfs->parent==NULL);

	uri_device=gnome_vfs_uri_new("file:///");
	g_assert(uri_device!=NULL);
	uri_device=gnome_vfs_uri_append_path(uri_device,device);
	g_assert(uri_device->parent==NULL);

	uri_libntfs->parent=uri_device;

	foreach_param->uri_list=g_list_prepend(foreach_param->uri_list,uri_libntfs);
}

static GList * /* of (GnomeVFSURI *) */ mod_uri_libntfs_proc_partitions(void)
{
/* map: (gchar *)device -> (gchar *)vol_name */
GHashTable *proc_partitions_ntfs_hash;
struct mod_uri_libntfs_proc_partitions_foreach_param foreach_param;

	proc_partitions_ntfs_hash=proc_partitions_ntfs_hash_get(optarg_verbose);

	foreach_param.proc_partitions_ntfs_hash=proc_partitions_ntfs_hash;
	foreach_param.uri_list=NULL;
	g_hash_table_foreach(proc_partitions_ntfs_hash,
			(GHFunc)mod_uri_libntfs_proc_partitions_foreach,	/* func */
			&foreach_param);	/* user_data */
	g_hash_table_destroy(proc_partitions_ntfs_hash);

	return foreach_param.uri_list;
}


static GList * /* of (GnomeVFSURI *) */ mod_uri_mtab(void)
{
struct mntent *mntent;
FILE *mntentfiler;
GList *uri_list;	/* of (GnomeVFSURI *) */
GnomeVFSURI *uri;

	if (!(mntentfiler=setmntent(FILENAME_ETC_MTAB,"r"))) {
		g_warning(_("Cannot open \"%s\" for reading: %m"),FILENAME_ETC_MTAB);
		return NULL;
		}
	uri_list=NULL;
	while ((mntent=getmntent(mntentfiler))) {
		if (!strcmp(mntent->mnt_type,"proc"))	/* optimize... */
			continue;
		uri=gnome_vfs_uri_new("file:///");
		g_assert(uri!=NULL);
		uri=gnome_vfs_uri_append_path(uri,mntent->mnt_dir);
		uri_list=g_list_prepend(uri_list,uri);
		}
	if (1!=endmntent(mntentfiler))
		g_warning(_("Cannot close \"%s\" after reading: %m"),FILENAME_ETC_MTAB);

	return uri_list;
}

static GList * /* of (GnomeVFSURI *) */ filter_non_local_uri(GList * /* of (GnomeVFSURI *) */ uri_list)
{
GList *uril;

	/* Filter-out non-local URIs */
	for (uril=uri_list;uril;) {
GnomeVFSURI *uri=uril->data;
GList *uril_remove;

		if (!gnome_vfs_uri_is_local(uri)) {
			if (optarg_verbose) {
gchar *uri_string;

				uri_string=gnome_vfs_uri_to_string(uri,GNOME_VFS_URI_HIDE_PASSWORD);
				g_message(_("Ignoring URI in auto-search as it is not local: %s"),uri_string);
				g_free(uri_string);
				}
			uril_remove=uril;
			uril=uril->next;
			gnome_vfs_uri_unref(uri);
			/* It is safe to be used during traversal this way: */
			uri_list=g_list_remove_link(uri_list,uril_remove);
			/* Prevent auto-traversal to the next list item: */
			continue;
			}
		uril=uril->next;
		}
	return uri_list;
}

GList * /* of (GnomeVFSURI *) */ mod_uri_list(void)
{
GList *uri_list;

	uri_list=NULL;

	uri_list=g_list_concat(uri_list,mod_uri_mtab());
	uri_list=g_list_concat(uri_list,mod_uri_libntfs_proc_partitions());

	uri_list=filter_non_local_uri(uri_list);

	return uri_list;
}
