/* $Id: final.c,v 1.1 2003/09/06 14:14:11 short Exp $
 * Final result message of drivers acquiring installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "final.h"	/* self */
#include <glib/gmessages.h>
#include <stdio.h>
#include <mntent.h>
#include <glib/gstring.h>
#include <string.h>

#include <captive/macros.h>


/* Config: */
#define FILENAME_ETC_FSTAB        "/etc/fstab"


gchar *final_text(gboolean all_modules_found)
{
const gchar *base;
FILE *mntentfiler;
struct mntent *mntent;
GString *gstring;
gboolean any_dirs_found;

	if (!all_modules_found)
		base=_(
				"Although essential modules (\"ntoskrnl.exe\" and \"ntfs.sys\") are available "
				"you may still want to get their better version and/or more modules. ");
	else 
		base=_("All needed modules were found in their best preferred versions.");
	gstring=g_string_new(base);

	any_dirs_found=FALSE;
	/* FIXME: locking! */
	if (!(mntentfiler=setmntent(FILENAME_ETC_FSTAB,"r")))
		g_error(_("Cannot open \"%s\" for reading: %m"),FILENAME_ETC_FSTAB);
	while ((mntent=getmntent(mntentfiler))) {
		if (strcmp(mntent->mnt_type,"captive-ntfs"))
			continue;
		if (!any_dirs_found) {
			gstring=g_string_append(gstring,captive_printf_alloca(_("\n"
					"Found NTFS disk partitions are prepared in %s. "
					"You can mount them by commands mount(8) or usermount(1) such as:\n"
					"\tmount /mnt/captive-LABEL_C\n"
					"Available captive-ntfs partitions:"),FILENAME_ETC_FSTAB));
			any_dirs_found=TRUE;
			}
		gstring=g_string_append(gstring,"\n\t");
		gstring=g_string_append(gstring,mntent->mnt_dir);
		}
	if (!any_dirs_found)
		gstring=g_string_append(gstring,_("\n"
				"Despite drivers were found no NTFS disk partitions were found on your computer. "
				"You still can mount read/write NTFS partitions by using filesystem type 'captive-ntfs' such as:\n"
				"\tmkdir /mnt/captive-LABEL_C\n"
				"\tmount -t captive-ntfs /dev/hda1 /mnt/captive-LABEL_C"));
	if (1!=endmntent(mntentfiler))
		g_warning(_("Cannot close \"%s\" after reading: %m"),FILENAME_ETC_FSTAB);
	
	return g_string_free(gstring,
			FALSE);	/* free_segment */
}
