/* $Id: microsoftcom.c,v 1.5 2005/12/25 10:31:46 lace Exp $
 * W32 modules finder from microsoft.com Internet download
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "microsoftcom.h"	/* self */
#include <glib/gmessages.h>
#include <libgnomevfs/gnome-vfs-uri.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <string.h>

#include <captive/macros.h>


/* Config: */
/* Do we really need to use indirection by the following 'base' URL?
 * It appears to me as if some Microsoft Service Pack files URLs
 * have changed in the past.
 * Currently we use fixed MICROSOFTDOWNLOAD_URL as we would have to
 * implement custom Gnome-VFS http timeouts as 'ACQUIRE_CABINET_READ_RAW_READ_TIMEOUT'.
 */
#if 0
#define MICROSOFTCOM_URL "http://www.microsoft.com/downloads/details.aspx?familyid=7a4d8d12-9f5d-42bb-b31c-7b31657c869c"
#else
#define MICROSOFTDOWNLOAD_URL "http://download.microsoft.com/download/e/c/6/ec6e00ab-ec05-4673-b8db-0658cf65f043/WindowsXP-KB835935-SP2-DEBUG-ENU.exe"
#endif


GList * /* of (GnomeVFSURI *) */ mod_uri_microsoftcom_list(void)
{
#ifdef MICROSOFTCOM_URL
int base_size;
char *base_contents,*href_end;
#endif
char *href;
GnomeVFSURI *uri;

#ifdef MICROSOFTCOM_URL
	base_contents=NULL;
	if (GNOME_VFS_OK!=gnome_vfs_read_entire_file(MICROSOFTCOM_URL,&base_size,&base_contents)
			|| base_size<=0) {
		g_warning(_("Cannot load base URL: %s"),MICROSOFTCOM_URL);
		goto fail_free_base_contents;
		}
	base_contents[base_size-1]=0;	/* string terminator */
	if (!(href=strstr(base_contents,"http://download.microsoft.com/")) || !(href_end=strchr(href,'"'))) {
		g_warning(_("Destination file URL not found in base URL: %s"),MICROSOFTCOM_URL);
		goto fail_free_base_contents;
		}
	*href_end=0;
#else
	href=MICROSOFTDOWNLOAD_URL;
#endif
	if (!(uri=gnome_vfs_uri_new(href))) {
		g_warning(_("Found destination file URL not parsable: %s"),href);
		goto fail_free_base_contents;
		}
#ifdef MICROSOFTCOM_URL
	g_free(base_contents);
#endif
	return g_list_append(NULL,uri);

fail_free_base_contents:
#ifdef MICROSOFTCOM_URL
	g_free(base_contents);
#endif
	return NULL;
}
