/* $Id: moduriload.h,v 1.4 2005/12/26 12:16:24 lace Exp $
 * Include file for W32 disk modules finder for acquiration installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_INSTALL_ACQUIRE_MODURILOAD_H
#define _CAPTIVE_INSTALL_ACQUIRE_MODURILOAD_H 1


#include <glib/gtypes.h>
#include <glib/ghash.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include <captive/captivemodid.h>


G_BEGIN_DECLS

struct module_available {
	struct captive_captivemodid_module *module;
	gpointer file_base;	/* of 'module->length' */
	gchar *uri_text;
	};

/* map: (const xmlChar *)type -> (struct module_available *) */
extern GHashTable *module_available_hash;

extern void (*acquire_module_available_notify)(struct module_available *module_available);
extern void (*acquire_module_all_modules_found_notify)(void);

void mod_uri_load_file_from_memory(gconstpointer file_base,size_t file_length,GnomeVFSURI *uri);
void mod_uri_load(GnomeVFSURI *uri);
void mod_uri_load_base_reporting(GnomeVFSURI *uri);

G_END_DECLS


#endif /* _CAPTIVE_INSTALL_ACQUIRE_MODURILOAD_H */
