/* $Id: standalone-libntfs.c,v 1.1 2005/12/27 09:05:29 lace Exp $
 * "libntfs" GnomeVFS method linked statically
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "standalone-libntfs.h"	/* self */

/* This include file is present only in GnomeVFS include-filesystems patched
 * version. See:
 * 	http://bugzilla.gnome.org/show_bug.cgi?id=47053
 */
#include <libgnomevfs/gnome-vfs-filesystem-entry.h>


GnomeVFSMethod *vfs_module_init(const char *method_name, const char *args);
GnomeVFSTransform *vfs_module_transform(const char *method_name, const char *config_args);
void vfs_module_shutdown(GnomeVFSMethod *method);

GnomeVFSTransform *vfs_module_transform(const char *method_name, const char *config_args)
{
	return NULL;
}

static const GnomeVFSIncludedFilesystem libntfs_gnomevfs={
	"libntfs",	/* filesystem_name */
	NULL,		/* filesystem_args */
	FALSE,		/* run_in_daemon */
	vfs_module_init,
	vfs_module_transform,
	vfs_module_shutdown,
	};


void standalone_libntfs_init(void)
{
	gnome_vfs_register_included_filesystem(&libntfs_gnomevfs);
}

/* This GCC version check is not exact or even right in any way. */
#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8)
void gnome_vfs_register_included_filesystem(const GnomeVFSIncludedFilesystem *included_filesystem) __attribute__((__weak__));
void gnome_vfs_register_included_filesystem(const GnomeVFSIncludedFilesystem *included_filesystem)
{
	g_error("Executable must be relinked with patched GnomeVFS: http://bugzilla.gnome.org/show_bug.cgi?id=47053");
}
#endif
